/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jdbc.BeanRowMapper;
import org.apache.camel.component.jdbc.DefaultBeanRowMapper;
import org.apache.camel.component.jdbc.DefaultJdbcPrepareStatementStrategy;
import org.apache.camel.component.jdbc.JdbcOutputType;
import org.apache.camel.component.jdbc.JdbcPrepareStatementStrategy;
import org.apache.camel.component.jdbc.JdbcProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="1.2.0", scheme="jdbc", title="JDBC", syntax="jdbc:dataSourceName", producerOnly=true, label="database,sql")
public class JdbcEndpoint
extends DefaultEndpoint {
    private DataSource dataSource;
    @UriPath
    @Metadata(required="true")
    private String dataSourceName;
    @UriParam
    private int readSize;
    @UriParam
    private boolean transacted;
    @UriParam(defaultValue="true")
    private boolean resetAutoCommit = true;
    @UriParam(prefix="statement.", multiValue=true)
    private Map<String, Object> parameters;
    @UriParam(defaultValue="true")
    private boolean useJDBC4ColumnNameAndLabelSemantics = true;
    @UriParam
    private boolean useGetBytesForBlob;
    @UriParam(label="advanced")
    private JdbcPrepareStatementStrategy prepareStatementStrategy = new DefaultJdbcPrepareStatementStrategy();
    @UriParam(defaultValue="true")
    private boolean allowNamedParameters = true;
    @UriParam
    private boolean useHeadersAsParameters;
    @UriParam(defaultValue="SelectList")
    private JdbcOutputType outputType = JdbcOutputType.SelectList;
    @UriParam
    private String outputClass;
    @UriParam(label="advanced")
    private BeanRowMapper beanRowMapper = new DefaultBeanRowMapper();

    public JdbcEndpoint() {
    }

    public JdbcEndpoint(String endpointUri, Component component, DataSource dataSource) {
        super(endpointUri, component);
        this.dataSource = dataSource;
    }

    public boolean isSingleton() {
        return true;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    public Producer createProducer() throws Exception {
        return new JdbcProducer(this, this.dataSource, this.readSize, this.parameters);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public int getReadSize() {
        return this.readSize;
    }

    public void setReadSize(int readSize) {
        this.readSize = readSize;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public boolean isResetAutoCommit() {
        return this.resetAutoCommit;
    }

    public void setResetAutoCommit(boolean resetAutoCommit) {
        this.resetAutoCommit = resetAutoCommit;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public boolean isUseJDBC4ColumnNameAndLabelSemantics() {
        return this.useJDBC4ColumnNameAndLabelSemantics;
    }

    public void setUseJDBC4ColumnNameAndLabelSemantics(boolean useJDBC4ColumnNameAndLabelSemantics) {
        this.useJDBC4ColumnNameAndLabelSemantics = useJDBC4ColumnNameAndLabelSemantics;
    }

    public JdbcPrepareStatementStrategy getPrepareStatementStrategy() {
        return this.prepareStatementStrategy;
    }

    public void setPrepareStatementStrategy(JdbcPrepareStatementStrategy prepareStatementStrategy) {
        this.prepareStatementStrategy = prepareStatementStrategy;
    }

    public boolean isAllowNamedParameters() {
        return this.allowNamedParameters;
    }

    public void setAllowNamedParameters(boolean allowNamedParameters) {
        this.allowNamedParameters = allowNamedParameters;
    }

    public boolean isUseHeadersAsParameters() {
        return this.useHeadersAsParameters;
    }

    public void setUseHeadersAsParameters(boolean useHeadersAsParameters) {
        this.useHeadersAsParameters = useHeadersAsParameters;
    }

    public JdbcOutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(JdbcOutputType outputType) {
        this.outputType = outputType;
    }

    public String getOutputClass() {
        return this.outputClass;
    }

    public void setOutputClass(String outputClass) {
        this.outputClass = outputClass;
    }

    public BeanRowMapper getBeanRowMapper() {
        return this.beanRowMapper;
    }

    public void setBeanRowMapper(BeanRowMapper beanRowMapper) {
        this.beanRowMapper = beanRowMapper;
    }

    public boolean isUseGetBytesForBlob() {
        return this.useGetBytesForBlob;
    }

    public void setUseGetBytesForBlob(boolean useGetBytesForBlob) {
        this.useGetBytesForBlob = useGetBytesForBlob;
    }

    protected String createEndpointUri() {
        return this.dataSourceName != null ? "jdbc:" + this.dataSourceName : "jdbc";
    }
}

