/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.ServletResolveConsumerStrategy;
import org.apache.camel.support.RestConsumerContextPathMatcher;

public class HttpServletResolveConsumerStrategy
implements ServletResolveConsumerStrategy {
    @Override
    public HttpConsumer resolve(HttpServletRequest request, Map<String, HttpConsumer> consumers) {
        return this.doResolve(request, request.getMethod(), consumers);
    }

    @Override
    public boolean isHttpMethodAllowed(HttpServletRequest request, String method, Map<String, HttpConsumer> consumers) {
        return this.doResolve(request, method, consumers) != null;
    }

    protected HttpConsumer doResolve(HttpServletRequest request, String method, Map<String, HttpConsumer> consumers) {
        String path = request.getPathInfo();
        if (path == null) {
            return null;
        }
        HttpConsumer answer = consumers.get(path);
        List<HttpConsumer> candidates = this.resolveCandidates(request, consumers);
        if ((candidates = candidates.stream().filter(c -> HttpServletResolveConsumerStrategy.matchRestMethod(method, c.getEndpoint().getHttpMethodRestrict())).collect(Collectors.toList())).size() == 1) {
            answer = candidates.get(0);
        }
        return answer;
    }

    private List<HttpConsumer> resolveCandidates(HttpServletRequest request, Map<String, HttpConsumer> consumers) {
        String path = request.getPathInfo();
        ArrayList<HttpConsumer> candidates = new ArrayList<HttpConsumer>();
        for (Map.Entry<String, HttpConsumer> entry : consumers.entrySet()) {
            HttpConsumer consumer;
            boolean matchOnUriPrefix;
            String consumerPath = entry.getValue().getPath();
            if (!RestConsumerContextPathMatcher.matchPath((String)path, (String)consumerPath, (boolean)(matchOnUriPrefix = (consumer = entry.getValue()).getEndpoint().isMatchOnUriPrefix()))) continue;
            candidates.add(consumer);
        }
        return candidates;
    }

    private static boolean matchRestMethod(String method, String restrict) {
        return restrict == null || restrict.toLowerCase(Locale.ENGLISH).contains(method.toLowerCase(Locale.ENGLISH));
    }
}

