/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.cxf.jaxrs.resources;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.camel.example.cxf.jaxrs.resources.Book;
import org.apache.camel.example.cxf.jaxrs.resources.BookNotFoundDetails;
import org.apache.camel.example.cxf.jaxrs.resources.BookNotFoundFault;
import org.apache.camel.example.cxf.jaxrs.resources.BookStore;

public class BookStoreImpl
implements BookStore {
    private Map<Long, Book> books = new HashMap<Long, Book>();
    private boolean isRest;

    public BookStoreImpl(boolean restFlag) {
        this.isRest = restFlag;
        this.init();
    }

    public BookStoreImpl() {
        this.init();
    }

    @Override
    public Book getBook(Long id) throws BookNotFoundFault {
        if (this.books.get(id) == null) {
            BookNotFoundDetails details = new BookNotFoundDetails();
            details.setId(id);
            if (!this.isRest) {
                throw new BookNotFoundFault("Can't find the Book with id " + id, details);
            }
            Response r = Response.status((int)404).header("BOOK-HEADER", (Object)("No Book with id " + id + " is available")).entity((Object)details).build();
            throw new WebApplicationException(r);
        }
        return this.books.get(id);
    }

    @Override
    public Book addBook(Book book) {
        this.books.put(book.getId(), book);
        return this.books.get(book.getId());
    }

    private void init() {
        Book book = new Book();
        book.setId(101L);
        book.setName("CXF User Guide");
        this.books.put(book.getId(), book);
    }
}

