/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.camel.transport;

import javax.xml.ws.Endpoint;
import org.apache.camel.example.camel.transport.GreeterImpl;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;

public class Server {
    Endpoint endpointA;
    Endpoint endpointB;

    public void prepare() throws Exception {
        System.setProperty("port", "9001");
        SpringBusFactory bf = new SpringBusFactory();
        BusFactory.setDefaultBus(null);
        Bus bus = bf.createBus("/org/apache/camel/example/camel/transport/CamelDestination.xml");
        BusFactory.setDefaultBus((Bus)bus);
    }

    public void start() throws Exception {
        System.out.println("Starting Server");
        GreeterImpl implementor = new GreeterImpl();
        implementor.setSuffix("EndpointA");
        String address = "camel://direct:EndpointA";
        this.endpointA = Endpoint.publish((String)address, (Object)implementor);
        implementor = new GreeterImpl();
        implementor.setSuffix("EndpointB");
        address = "camel://direct:EndpointB";
        this.endpointB = Endpoint.publish((String)address, (Object)implementor);
    }

    public void stop() {
        if (this.endpointA != null) {
            this.endpointA.stop();
        }
        if (this.endpointB != null) {
            this.endpointB.stop();
        }
    }

    public static void main(String[] args) throws Exception {
        Server server = new Server();
        server.prepare();
        server.start();
        System.out.println("Server ready...");
        Thread.sleep(300000L);
        System.out.println("Server exiting");
        server.stop();
        System.exit(0);
    }
}

