/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import com.azure.security.keyvault.secrets.SecretClient;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.azure.key.vault.KeyVaultOperation;

public interface KeyVaultEndpointBuilderFactory {
    public static KeyVaultEndpointBuilder endpointBuilder(String componentName, String path) {
        class KeyVaultEndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements KeyVaultEndpointBuilder,
        AdvancedKeyVaultEndpointBuilder {
            final /* synthetic */ String val$componentName;

            public KeyVaultEndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new KeyVaultEndpointBuilderImpl(path, componentName);
    }

    public static class KeyVaultHeaderNameBuilder {
        private static final KeyVaultHeaderNameBuilder INSTANCE = new KeyVaultHeaderNameBuilder();

        public String azureKeyVaultProducerOperation() {
            return "AzureKeyVaultProducerOperation";
        }

        public String azureKeyVaultSecretName() {
            return "AzureKeyVaultSecretName";
        }
    }

    public static interface KeyVaultBuilders {
        default public KeyVaultHeaderNameBuilder azureKeyVault() {
            return KeyVaultHeaderNameBuilder.INSTANCE;
        }

        default public KeyVaultEndpointBuilder azureKeyVault(String path) {
            return KeyVaultEndpointBuilderFactory.endpointBuilder("azure-key-vault", path);
        }

        default public KeyVaultEndpointBuilder azureKeyVault(String componentName, String path) {
            return KeyVaultEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedKeyVaultEndpointBuilder
    extends EndpointProducerBuilder {
        default public KeyVaultEndpointBuilder basic() {
            return (KeyVaultEndpointBuilder)((Object)this);
        }

        default public AdvancedKeyVaultEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedKeyVaultEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public static interface KeyVaultEndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedKeyVaultEndpointBuilder advanced() {
            return (AdvancedKeyVaultEndpointBuilder)((Object)this);
        }

        default public KeyVaultEndpointBuilder operation(KeyVaultOperation operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public KeyVaultEndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public KeyVaultEndpointBuilder secretClient(SecretClient secretClient) {
            this.doSetProperty("secretClient", secretClient);
            return this;
        }

        default public KeyVaultEndpointBuilder secretClient(String secretClient) {
            this.doSetProperty("secretClient", secretClient);
            return this;
        }

        default public KeyVaultEndpointBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public KeyVaultEndpointBuilder clientSecret(String clientSecret) {
            this.doSetProperty("clientSecret", clientSecret);
            return this;
        }

        default public KeyVaultEndpointBuilder tenantId(String tenantId) {
            this.doSetProperty("tenantId", tenantId);
            return this;
        }
    }
}

