/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.cassandra;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultExchangeHolder;

public class CassandraCamelCodec {
    public ByteBuffer marshallExchange(CamelContext camelContext, Exchange exchange, boolean allowSerializedHeaders) throws IOException {
        DefaultExchangeHolder pe = DefaultExchangeHolder.marshal((Exchange)exchange, (boolean)false, (boolean)allowSerializedHeaders);
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedSize", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedSize", Integer.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedTimeout", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedTimeout", Long.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCompletedBy", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedCompletedBy", String.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCorrelationKey", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedCorrelationKey", String.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCollectionGuard", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedCollectionGuard", String.class)));
        if (exchange.getFromEndpoint() != null) {
            DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedFromEndpoint", (Serializable)((Object)exchange.getFromEndpoint().getEndpointUri()));
        }
        return ByteBuffer.wrap(this.serialize(pe));
    }

    public Exchange unmarshallExchange(CamelContext camelContext, ByteBuffer buffer) throws IOException, ClassNotFoundException {
        Endpoint fromEndpoint;
        DefaultExchangeHolder pe = (DefaultExchangeHolder)this.deserialize(new ByteBufferInputStream(buffer));
        DefaultExchange answer = new DefaultExchange(camelContext);
        DefaultExchangeHolder.unmarshal((Exchange)answer, (DefaultExchangeHolder)pe);
        String fromEndpointUri = (String)answer.removeProperty("CamelAggregatedFromEndpoint");
        if (fromEndpointUri != null && (fromEndpoint = camelContext.hasEndpoint(fromEndpointUri)) != null) {
            answer.setFromEndpoint(fromEndpoint);
        }
        return answer;
    }

    private byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objectOut = new ObjectOutputStream(bytesOut);
        objectOut.writeObject(object);
        objectOut.close();
        return bytesOut.toByteArray();
    }

    private Object deserialize(InputStream bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream objectIn = new ObjectInputStream(bytes);
        Object object = objectIn.readObject();
        objectIn.close();
        return object;
    }

    private static class ByteBufferInputStream
    extends InputStream {
        private final ByteBuffer buffer;

        ByteBufferInputStream(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public int read() throws IOException {
            if (!this.buffer.hasRemaining()) {
                return -1;
            }
            return this.buffer.get();
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buffer.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buffer.remaining());
            this.buffer.get(bytes, off, len);
            return len;
        }
    }
}

