/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import org.apache.camel.CamelContext;
import org.apache.camel.core.osgi.OsgiDataFormatResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatFactory;
import org.apache.camel.spi.DataFormatResolver;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintDataFormatResolver
extends OsgiDataFormatResolver {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintDataFormatResolver.class);

    public BlueprintDataFormatResolver(BundleContext bundleContext) {
        super(bundleContext);
    }

    public DataFormat resolveDataFormat(String name, CamelContext context) {
        DataFormat dataFormat = null;
        DataFormatResolver resolver = (DataFormatResolver)context.getRegistry().lookupByNameAndType(".camelBlueprint.dataformatResolver." + name, DataFormatResolver.class);
        if (resolver != null) {
            LOG.debug("Found dataformat resolver: {} in registry: {}", (Object)name, (Object)resolver);
            dataFormat = resolver.resolveDataFormat(name, context);
        }
        if (dataFormat == null) {
            dataFormat = super.resolveDataFormat(name, context);
        }
        return dataFormat;
    }

    public DataFormat createDataFormat(String name, CamelContext context) {
        DataFormatFactory factory = (DataFormatFactory)context.getRegistry().lookupByNameAndType(".camelBlueprint.dataformatFactory." + name, DataFormatFactory.class);
        if (factory != null) {
            LOG.debug("Found dataformat factory: {} in registry: {}", (Object)name, (Object)factory);
            return factory.newInstance();
        }
        return super.createDataFormat(name, context);
    }
}

