/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.BeanScope;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.BeanProducer;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.component.bean.ParameterMappingStrategyHelper;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.component.bean.RequestBeanHolder;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="1.0.0", scheme="bean", title="Bean", syntax="bean:beanName", producerOnly=true, remote=false, category={Category.CORE, Category.SCRIPT})
public class BeanEndpoint
extends DefaultEndpoint {
    private transient BeanHolder beanHolder;
    private transient BeanProcessor processor;
    @UriPath(label="common", description="Sets the name of the bean to invoke")
    @Metadata(required=true)
    private String beanName;
    @UriParam(label="common", description="Sets the name of the method to invoke on the bean")
    private String method;
    @UriParam(label="common", defaultValue="Singleton", description="Scope of bean. When using singleton scope (default) the bean is created or looked up only once and reused for the lifetime of the endpoint. The bean should be thread-safe in case concurrent threads is calling the bean at the same time. When using request scope the bean is created or looked up once per request (exchange). This can be used if you want to store state on a bean while processing a request and you want to call the same bean instance multiple times while processing the request. The bean does not have to be thread-safe as the instance is only called from the same request. When using prototype scope, then the bean will be looked up or created per call. However in case of lookup then this is delegated  to the bean registry such as Spring or CDI (if in use), which depends on their configuration can act as either singleton or prototype scope. so when using prototype then this depends on the delegated registry.")
    private BeanScope scope = BeanScope.Singleton;
    @UriParam(prefix="bean.", label="advanced", description="Used for configuring additional properties on the bean", multiValue=true)
    private Map<String, Object> parameters;

    public BeanEndpoint() {
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public BeanEndpoint(String endpointUri, Component component, BeanProcessor processor) {
        super(endpointUri, component);
        this.processor = processor;
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public BeanEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public boolean isRemote() {
        return false;
    }

    public Producer createProducer() throws Exception {
        return new BeanProducer(this, this.processor);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot consume from a bean endpoint");
    }

    public BeanProcessor getProcessor() {
        return this.processor;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.processor == null) {
            ObjectHelper.notNull((Object)this.beanName, (String)"beanName", (Object)((Object)this));
            BeanHolder holder = this.getBeanHolder();
            if (holder == null) {
                ParameterMappingStrategy strategy = ParameterMappingStrategyHelper.createParameterMappingStrategy(this.getCamelContext());
                BeanComponent bean = (BeanComponent)this.getCamelContext().getComponent("bean", BeanComponent.class);
                RegistryBean registryBean = new RegistryBean(this.getCamelContext(), this.beanName, strategy, bean);
                holder = this.scope == BeanScope.Singleton ? registryBean.createCacheHolder() : registryBean;
            }
            if (this.scope == BeanScope.Request) {
                holder = new RequestBeanHolder(holder);
            }
            this.processor = new BeanProcessor(holder);
            if (this.method != null) {
                this.processor.setMethod(this.method);
            }
            this.processor.setScope(this.scope);
            if (this.parameters != null) {
                holder.setOptions(this.parameters);
            }
        }
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public BeanScope getScope() {
        return this.scope;
    }

    public void setScope(BeanScope scope) {
        this.scope = scope;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public BeanHolder getBeanHolder() {
        return this.beanHolder;
    }

    public void setBeanHolder(BeanHolder beanHolder) {
        this.beanHolder = beanHolder;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    protected String createEndpointUri() {
        return "bean:" + this.getBeanName() + (String)(this.method != null ? "?method=" + this.method : "");
    }
}

