/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.engine.DefaultResourceResolvers;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceResolver;
import org.apache.camel.support.ResourceResolverSupport;

public class DefaultFallbackResourceResolver
extends ResourceResolverSupport {
    private final ResourceResolver classpath;
    private final ResourceResolver file;

    public DefaultFallbackResourceResolver(CamelContext camelContext) {
        super("");
        this.setCamelContext(camelContext);
        this.classpath = new DefaultResourceResolvers.ClasspathResolver();
        this.classpath.setCamelContext(camelContext);
        this.file = new DefaultResourceResolvers.FileResolver();
        this.file.setCamelContext(camelContext);
    }

    public Resource resolve(String location) {
        if (location.contains("{{") && location.contains("}}")) {
            location = this.getCamelContext().getPropertiesComponent().parseUri(location);
        }
        return this.createResource(location, null);
    }

    protected Resource createResource(String location, String remaining) {
        Resource special;
        Resource answer = this.classpath.resolve(this.classpath.getSupportedScheme() + ":" + location);
        if ((answer == null || !answer.exists() && location.endsWith(".groovy")) && (special = super.resolve(this.classpath.getSupportedScheme() + ":camel-groovy/" + location)) != null && special.exists()) {
            answer = special;
        }
        if ((answer == null || !answer.exists()) && (special = this.file.resolve(this.file.getSupportedScheme() + ":" + location)) != null && special.exists()) {
            answer = special;
        }
        return answer;
    }
}

