/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExchangeFactoryManager;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.PooledObjectFactorySupport;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrototypeExchangeFactory
extends PooledObjectFactorySupport<Exchange>
implements ExchangeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PrototypeExchangeFactory.class);
    final Consumer consumer;
    ExchangeFactoryManager exchangeFactoryManager;
    String routeId;

    public PrototypeExchangeFactory() {
        this.consumer = null;
    }

    public PrototypeExchangeFactory(Consumer consumer) {
        this.consumer = consumer;
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        this.exchangeFactoryManager = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getExchangeFactoryManager();
        DefaultExchange dummy = new DefaultExchange(this.camelContext);
        dummy.getIn();
        dummy.getIn().getHeaders();
        LOG.trace("Warming up PrototypeExchangeFactory loaded class: {}", (Object)dummy.getClass().getName());
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public ExchangeFactory newExchangeFactory(Consumer consumer) {
        PrototypeExchangeFactory answer = new PrototypeExchangeFactory(consumer);
        answer.setStatisticsEnabled(this.statisticsEnabled);
        answer.setCapacity(this.capacity);
        answer.setCamelContext(this.camelContext);
        return answer;
    }

    public Exchange acquire() {
        throw new UnsupportedOperationException("Not in use");
    }

    public Exchange create(boolean autoRelease) {
        if (this.statisticsEnabled) {
            this.statistics.created.increment();
        }
        return new DefaultExchange(this.camelContext);
    }

    public Exchange create(Endpoint fromEndpoint, boolean autoRelease) {
        if (this.statisticsEnabled) {
            this.statistics.created.increment();
        }
        return new DefaultExchange(fromEndpoint);
    }

    public boolean release(Exchange exchange) {
        if (this.statisticsEnabled) {
            this.statistics.released.increment();
        }
        return true;
    }

    public boolean isPooled() {
        return false;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.exchangeFactoryManager != null) {
            this.exchangeFactoryManager.addExchangeFactory((ExchangeFactory)this);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.exchangeFactoryManager != null) {
            this.exchangeFactoryManager.removeExchangeFactory((ExchangeFactory)this);
        }
        this.logUsageSummary(LOG, "PrototypeExchangeFactory", 0);
    }

    void logUsageSummary(Logger log, String name, int pooled) {
        if (this.statisticsEnabled && this.consumer != null) {
            boolean shouldLog;
            long created = this.statistics.getCreatedCounter();
            long acquired = this.statistics.getAcquiredCounter();
            long released = this.statistics.getReleasedCounter();
            long discarded = this.statistics.getDiscardedCounter();
            boolean bl = shouldLog = pooled > 0 || created > 0L || acquired > 0L || released > 0L || discarded > 0L;
            if (shouldLog) {
                boolean leak;
                String id = this.getRouteId();
                String uri = this.consumer.getEndpoint().getEndpointBaseUri();
                uri = URISupport.sanitizeUri((String)uri);
                boolean bl2 = leak = created + acquired > released + discarded;
                if (leak) {
                    long leaks = created + acquired - (released + discarded);
                    log.info("{} {} ({}) usage (leaks detected: {}) [pooled: {}, created: {}, acquired: {} released: {}, discarded: {}]", new Object[]{name, id, uri, leaks, pooled, created, acquired, released, discarded});
                } else {
                    log.info("{} {} ({}) usage [pooled: {}, created: {}, acquired: {} released: {}, discarded: {}]", new Object[]{name, id, uri, pooled, created, acquired, released, discarded});
                }
            }
        }
    }
}

