/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.attachment;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;

public class NoSuchAttachmentException
extends CamelExchangeException {
    private final String attachmentName;
    private final transient Class<?> type;

    public NoSuchAttachmentException(Exchange exchange, String attachmentName) {
        this(exchange, attachmentName, null);
    }

    public NoSuchAttachmentException(Exchange exchange, String attachmentName, Class<?> type) {
        super("No '" + attachmentName + "' attachment available" + (String)(type != null ? " of type: " + type.getName() : "") + NoSuchAttachmentException.reason(exchange, attachmentName), exchange);
        this.attachmentName = attachmentName;
        this.type = type;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public Class<?> getType() {
        return this.type;
    }

    protected static String reason(Exchange exchange, String propertyName) {
        Object value = exchange.getProperty(propertyName);
        return NoSuchAttachmentException.valueDescription(value);
    }

    static String valueDescription(Object value) {
        if (value == null) {
            return "";
        }
        return " but has type: " + value.getClass().getCanonicalName();
    }
}

