/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.attachment;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.util.CollectionHelper;

public class DefaultAttachment
implements Attachment {
    private final DataHandler dataHandler;
    private Map<String, Object> headers;

    public DefaultAttachment(DataHandler dh) {
        this.dataHandler = dh;
    }

    public DefaultAttachment(DataSource ds) {
        this.dataHandler = new DataHandler(ds);
    }

    @Override
    public DataHandler getDataHandler() {
        return this.dataHandler;
    }

    @Override
    public String getHeader(String name) {
        if (this.headers != null) {
            Object headerObject = this.headers.get(name);
            if (headerObject instanceof String) {
                return (String)headerObject;
            }
            if (headerObject instanceof Collection) {
                return CollectionHelper.collectionAsCommaDelimitedString((Collection)((Collection)headerObject));
            }
        }
        return null;
    }

    @Override
    public List<String> getHeaderAsList(String name) {
        if (this.headers != null) {
            Object headerObject = this.headers.get(name);
            if (headerObject instanceof List) {
                return (List)headerObject;
            }
            if (headerObject instanceof String) {
                return Collections.singletonList((String)headerObject);
            }
        }
        return null;
    }

    @Override
    public void addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        CollectionHelper.appendValue(this.headers, (String)name, (Object)value);
    }

    @Override
    public void setHeader(String headerName, String value) {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        this.headers.put(headerName, value);
    }

    @Override
    public void removeHeader(String name) {
        if (this.headers != null) {
            this.headers.remove(name);
        }
    }

    @Override
    public Collection<String> getHeaderNames() {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        return this.headers.keySet();
    }

    public void clearHeaders() {
        this.headers = null;
    }

    private Map<String, Object> createHeaders() {
        return new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    }

    public boolean equals(Object other) {
        if (other instanceof Attachment) {
            DataHandler otherDh = ((Attachment)other).getDataHandler();
            return this.dataHandler.equals(otherDh);
        }
        return false;
    }

    public int hashCode() {
        return this.dataHandler.hashCode();
    }
}

