/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.attachment;

import jakarta.activation.DataHandler;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.attachment.DefaultAttachmentMessage;

public class CSimpleAttachmentHelper {
    private static AttachmentMessage toAttachmentMessage(Exchange exchange) {
        AttachmentMessage am;
        Message message = exchange.getMessage();
        AttachmentMessage answer = message instanceof AttachmentMessage ? (am = (AttachmentMessage)message) : new DefaultAttachmentMessage(exchange.getMessage());
        return answer;
    }

    public static Map<String, DataHandler> attachments(Exchange exchange) {
        return CSimpleAttachmentHelper.toAttachmentMessage(exchange).getAttachments();
    }

    public static int attachmentsSize(Exchange exchange) {
        return CSimpleAttachmentHelper.toAttachmentMessage(exchange).getAttachments().size();
    }

    public static Object attachmentContent(Exchange exchange, String key) throws Exception {
        DataHandler dh = CSimpleAttachmentHelper.toAttachmentMessage(exchange).getAttachments().get(key);
        if (dh != null) {
            return dh.getContent();
        }
        return null;
    }

    public static String attachmentContentAsText(Exchange exchange, String key) throws Exception {
        Object data = CSimpleAttachmentHelper.attachmentContent(exchange, key);
        if (data != null) {
            return (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, data);
        }
        return null;
    }

    public static <T> T attachmentContentAs(Exchange exchange, String key, Class<T> type) throws Exception {
        Object data = CSimpleAttachmentHelper.attachmentContent(exchange, key);
        if (data != null) {
            return (T)exchange.getContext().getTypeConverter().convertTo(type, exchange, data);
        }
        return null;
    }

    public static String attachmentContentType(Exchange exchange, String key) {
        DataHandler dh = CSimpleAttachmentHelper.toAttachmentMessage(exchange).getAttachments().get(key);
        if (dh != null) {
            return dh.getContentType();
        }
        return null;
    }

    public static String attachmentHeader(Exchange exchange, String key, String name) {
        Attachment ao = CSimpleAttachmentHelper.toAttachmentMessage(exchange).getAttachmentObjects().get(key);
        if (ao != null) {
            return ao.getHeader(name);
        }
        return null;
    }

    public static <T> T attachmentHeaderAs(Exchange exchange, String key, String name, Class<T> type) {
        String data = CSimpleAttachmentHelper.attachmentHeader(exchange, key, name);
        if (data != null) {
            return (T)exchange.getContext().getTypeConverter().convertTo(type, exchange, (Object)data);
        }
        return null;
    }
}

