/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.Caches;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.StateFetchingIterators;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MultimapSideInput<@UnknownKeyFor K, @UnknownKeyFor V>
implements Materializations.MultimapView<K, V> {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cache;
    private final @UnknownKeyFor @NonNull @Initialized BeamFnStateClient beamFnStateClient;
    private final  @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest keysRequest;
    private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;

    public MultimapSideInput(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cache, @UnknownKeyFor @NonNull @Initialized BeamFnStateClient beamFnStateClient, @UnknownKeyFor @NonNull @Initialized String instructionId,  @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateKey stateKey, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        Preconditions.checkArgument((boolean)stateKey.hasMultimapKeysSideInput(), (String)"Expected MultimapKeysSideInput StateKey but received %s.", (Object)stateKey);
        this.cache = cache;
        this.beamFnStateClient = beamFnStateClient;
        this.keysRequest = BeamFnApi.StateRequest.newBuilder().setInstructionId(instructionId).setStateKey(stateKey).build();
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<K> get() {
        return StateFetchingIterators.readAllAndDecodeStartingFrom(this.cache, this.beamFnStateClient, this.keysRequest, this.keyCoder);
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<V> get(K k) {
        ByteStringOutputStream output = new ByteStringOutputStream();
        try {
            this.keyCoder.encode(k, (OutputStream)output);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to encode key %s for side input id %s.", k, this.keysRequest.getStateKey().getMultimapKeysSideInput().getSideInputId()), e);
        }
        ByteString encodedKey = output.toByteString();
        BeamFnApi.StateKey stateKey = BeamFnApi.StateKey.newBuilder().setMultimapSideInput(BeamFnApi.StateKey.MultimapSideInput.newBuilder().setTransformId(this.keysRequest.getStateKey().getMultimapKeysSideInput().getTransformId()).setSideInputId(this.keysRequest.getStateKey().getMultimapKeysSideInput().getSideInputId()).setWindow(this.keysRequest.getStateKey().getMultimapKeysSideInput().getWindow()).setKey(encodedKey)).build();
        BeamFnApi.StateRequest request = this.keysRequest.toBuilder().setStateKey(stateKey).build();
        return StateFetchingIterators.readAllAndDecodeStartingFrom(Caches.subCache(this.cache, "ValuesForKey", encodedKey), this.beamFnStateClient, request, this.valueCoder);
    }
}

