/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.beam.sdk.fn.stream.PrefetchableIterables;
import org.apache.beam.sdk.fn.stream.PrefetchableIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

class LazyCachingIteratorToIterable<@UnknownKeyFor T>
extends PrefetchableIterables.Default<T> {
    private final @UnknownKeyFor @NonNull @Initialized List<T> cachedElements = new ArrayList<T>();
    private final @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> iterator;

    public LazyCachingIteratorToIterable(@UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> iterator) {
        this.iterator = iterator;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> createIterator() {
        return new CachingIterator();
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.iterator.hasNext() ? Objects.hashCode(this.iterator.next()) : -1789023489;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        return obj instanceof Iterable && Iterables.elementsEqual((Iterable)this, (Iterable)((Iterable)obj));
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return Iterables.toString((Iterable)this);
    }

    private class CachingIterator
    implements PrefetchableIterator<T> {
        private @UnknownKeyFor @NonNull @Initialized int position = 0;

        private CachingIterator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isReady() {
            if (this.position < LazyCachingIteratorToIterable.this.cachedElements.size()) {
                return true;
            }
            return LazyCachingIteratorToIterable.this.iterator.isReady();
        }

        @Override
        public void prefetch() {
            if (!this.isReady()) {
                LazyCachingIteratorToIterable.this.iterator.prefetch();
            }
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
            return this.position < LazyCachingIteratorToIterable.this.cachedElements.size() || LazyCachingIteratorToIterable.this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (this.position < LazyCachingIteratorToIterable.this.cachedElements.size()) {
                return LazyCachingIteratorToIterable.this.cachedElements.get(this.position++);
            }
            if (!LazyCachingIteratorToIterable.this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            Object rval = LazyCachingIteratorToIterable.this.iterator.next();
            LazyCachingIteratorToIterable.this.cachedElements.add(rval);
            ++this.position;
            return rval;
        }
    }
}

