/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.resolver.obr.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.application.modelling.Provider;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.DataModelHelper;
import org.apache.felix.bundlerepository.Property;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBRCapability
implements Capability {
    private Logger logger = LoggerFactory.getLogger(OBRCapability.class);
    private final Provider _provider;
    private final RepositoryAdmin repositoryAdmin;
    private final Map<String, Object> _props;

    public OBRCapability(Provider provider, RepositoryAdmin repositoryAdmin) {
        this.logger.debug("Method entry: {}, args {}", (Object)"OBRCapability", (Object)provider);
        this._provider = provider;
        this._props = new HashMap<String, Object>(provider.getAttributes());
        this.repositoryAdmin = repositoryAdmin;
        this.logger.debug("Method exit: {}, returning {}", (Object)"OBRCapability");
    }

    public String getName() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getName");
        String name = this._provider.getType().toString();
        this.logger.debug("Method exit: {}, returning {}", (Object)"getName", (Object)name);
        return name;
    }

    public Property[] getProperties() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getProperties");
        DataModelHelper helper = this.repositoryAdmin.getHelper();
        ArrayList<Property> properties = new ArrayList<Property>();
        for (final Map.Entry<String, Object> entry : this._props.entrySet()) {
            String propXML = helper.writeProperty(new Property(){

                public String getValue() {
                    Object value = entry.getValue();
                    if (value instanceof String[]) {
                        String newValue = Arrays.toString((String[])value);
                        value = newValue.substring(1, newValue.length() - 1);
                    } else if (value instanceof Collection) {
                        String newValue = Arrays.toString(((Collection)value).toArray());
                        value = newValue.substring(1, newValue.length() - 1);
                    }
                    return String.valueOf(value);
                }

                public String getType() {
                    String name = (String)entry.getKey();
                    String type = null;
                    if ("version".equals(name) || "bundle-version".equals(name)) {
                        type = "version";
                    } else if ("objectClass".equals(name) || "mandatory:".equals(name) || entry.getValue() instanceof String[] || entry.getValue() instanceof Collection) {
                        type = "set";
                    }
                    return type;
                }

                public String getName() {
                    return (String)entry.getKey();
                }

                public Object getConvertedValue() {
                    return null;
                }
            });
            try {
                properties.add(helper.readProperty(propXML));
            }
            catch (Exception e) {}
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"getProperties", properties);
        return properties.toArray(new Property[properties.size()]);
    }

    public Map getPropertiesAsMap() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getPropertiesAsMap");
        this.logger.debug("Method entry: {}, args {}", (Object)"getPropertiesAsMap", (Object)new Object[]{this._props});
        return this._props;
    }
}

