/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;
import org.apache.activemq.artemis.utils.HashProcessor;

public class SecureHashProcessor
implements HashProcessor {
    private static final String BEGIN_HASH = "ENC(";
    private static final String END_HASH = ")";
    private DefaultSensitiveStringCodec codec;

    public SecureHashProcessor(DefaultSensitiveStringCodec codec) {
        this.codec = codec;
    }

    @Override
    public String hash(String plainText) throws Exception {
        return BEGIN_HASH + this.codec.encode(plainText) + END_HASH;
    }

    @Override
    public boolean compare(char[] inputValue, String storedValue) {
        String storedHash = storedValue.substring(4, storedValue.length() - 2);
        return this.codec.verify(inputValue, storedHash);
    }
}

