/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Iterator;
import java.util.List;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedCircuitBreakerLoadBalancerMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.processor.loadbalancer.CircuitBreakerLoadBalancer;
import org.apache.camel.processor.loadbalancer.ExceptionFailureStatistics;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed CircuitBreaker LoadBalancer")
public class ManagedCircuitBreakerLoadBalancer
extends ManagedProcessor
implements ManagedCircuitBreakerLoadBalancerMBean {
    private final CircuitBreakerLoadBalancer processor;
    private String exceptions;

    public ManagedCircuitBreakerLoadBalancer(CamelContext context, CircuitBreakerLoadBalancer processor, LoadBalanceDefinition definition) {
        super(context, processor, definition);
        this.processor = processor;
    }

    @Override
    public Boolean getSupportExtendedInformation() {
        return true;
    }

    @Override
    public Integer getSize() {
        return this.processor.getProcessors().size();
    }

    @Override
    public Long getHalfOpenAfter() {
        return this.processor.getHalfOpenAfter();
    }

    @Override
    public Integer getThreshold() {
        return this.processor.getThreshold();
    }

    @Override
    public String getExceptions() {
        if (this.exceptions != null) {
            return this.exceptions;
        }
        List<Class<?>> classes = this.processor.getExceptions();
        if (classes == null || classes.isEmpty()) {
            this.exceptions = "";
        } else {
            CollectionStringBuffer csb = new CollectionStringBuffer(",");
            for (Class<?> clazz : classes) {
                csb.append(clazz.getCanonicalName());
            }
            this.exceptions = csb.toString();
        }
        return this.exceptions;
    }

    @Override
    public String getCircuitBreakerState() {
        int num = this.processor.getState();
        if (num == 0) {
            return "closed";
        }
        if (num == 1) {
            return "half open";
        }
        return "open";
    }

    @Override
    public String dumpState() {
        return this.processor.dumpState();
    }

    @Override
    public TabularData exceptionStatistics() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.loadbalancerExceptionsTabularType());
            ExceptionFailureStatistics statistics = this.processor.getExceptionFailureStatistics();
            Iterator<Class<?>> it = statistics.getExceptions();
            boolean empty = true;
            while (it.hasNext()) {
                empty = false;
                Class<?> exception = it.next();
                String name = ObjectHelper.name(exception);
                long counter = statistics.getFailureCounter(exception);
                CompositeType ct = CamelOpenMBeanTypes.loadbalancerExceptionsCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"exception", "failures"}, new Object[]{name, counter});
                answer.put(data);
            }
            if (empty) {
                String name = ObjectHelper.name(Exception.class);
                long counter = statistics.getFailureCounter(Exception.class);
                CompositeType ct = CamelOpenMBeanTypes.loadbalancerExceptionsCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"exception", "failures"}, new Object[]{name, counter});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }
}

