/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.activation.DataHandler;
import org.apache.camel.Attachment;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultAttachment;
import org.apache.camel.impl.MessageSupport;
import org.apache.camel.util.AttachmentMap;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;

public class DefaultMessage
extends MessageSupport {
    private boolean fault;
    private Map<String, Object> headers;
    private Map<String, DataHandler> attachments;
    private Map<String, Attachment> attachmentObjects;

    @Override
    public boolean isFault() {
        return this.fault;
    }

    @Override
    public void setFault(boolean fault) {
        this.fault = fault;
    }

    @Override
    public Object getHeader(String name) {
        if (this.hasHeaders()) {
            return this.getHeaders().get(name);
        }
        return null;
    }

    @Override
    public Object getHeader(String name, Object defaultValue) {
        Object answer = this.getHeaders().get(name);
        return answer != null ? answer : defaultValue;
    }

    @Override
    public Object getHeader(String name, Supplier<Object> defaultValueSupplier) {
        ObjectHelper.notNull(name, "name");
        ObjectHelper.notNull(defaultValueSupplier, "defaultValueSupplier");
        Object answer = this.getHeaders().get(name);
        return answer != null ? answer : defaultValueSupplier.get();
    }

    @Override
    public <T> T getHeader(String name, Class<T> type) {
        Object value = this.getHeader(name);
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            return e.getContext().getTypeConverter().convertTo(type, e, value);
        }
        return type.cast(value);
    }

    @Override
    public <T> T getHeader(String name, Object defaultValue, Class<T> type) {
        Object value = this.getHeader(name, defaultValue);
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            return e.getContext().getTypeConverter().convertTo(type, e, value);
        }
        return type.cast(value);
    }

    @Override
    public <T> T getHeader(String name, Supplier<Object> defaultValueSupplier, Class<T> type) {
        ObjectHelper.notNull(name, "name");
        ObjectHelper.notNull(type, "type");
        ObjectHelper.notNull(defaultValueSupplier, "defaultValueSupplier");
        Object value = this.getHeader(name, defaultValueSupplier);
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            return e.getContext().getTypeConverter().convertTo(type, e, value);
        }
        return type.cast(value);
    }

    @Override
    public void setHeader(String name, Object value) {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        this.headers.put(name, value);
    }

    @Override
    public Object removeHeader(String name) {
        if (!this.hasHeaders()) {
            return null;
        }
        return this.headers.remove(name);
    }

    @Override
    public boolean removeHeaders(String pattern) {
        return this.removeHeaders(pattern, null);
    }

    @Override
    public boolean removeHeaders(String pattern, String ... excludePatterns) {
        if (!this.hasHeaders()) {
            return false;
        }
        boolean matches = false;
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
            String key = entry.getKey();
            if (!EndpointHelper.matchPattern(key, pattern) || excludePatterns != null && DefaultMessage.isExcludePatternMatch(key, excludePatterns)) continue;
            matches = true;
            toRemove.add(entry.getKey());
        }
        for (String key : toRemove) {
            this.headers.remove(key);
        }
        return matches;
    }

    @Override
    public Map<String, Object> getHeaders() {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers instanceof CaseInsensitiveMap ? headers : new CaseInsensitiveMap((Map<? extends String, ?>)headers);
    }

    @Override
    public boolean hasHeaders() {
        if (!this.hasPopulatedHeaders()) {
            this.getHeaders();
        }
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public DefaultMessage newInstance() {
        return new DefaultMessage();
    }

    protected Map<String, Object> createHeaders() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        this.populateInitialHeaders(map);
        return map;
    }

    protected Map<String, Attachment> createAttachments() {
        LinkedHashMap<String, Attachment> map = new LinkedHashMap<String, Attachment>();
        this.populateInitialAttachments(map);
        return map;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
    }

    protected void populateInitialAttachments(Map<String, Attachment> map) {
    }

    protected Boolean isTransactedRedelivered() {
        return null;
    }

    @Override
    public void addAttachment(String id, DataHandler content) {
        this.addAttachmentObject(id, new DefaultAttachment(content));
    }

    @Override
    public void addAttachmentObject(String id, Attachment content) {
        if (this.attachmentObjects == null) {
            this.attachmentObjects = this.createAttachments();
        }
        this.attachmentObjects.put(id, content);
    }

    @Override
    public DataHandler getAttachment(String id) {
        Attachment att = this.getAttachmentObject(id);
        if (att == null) {
            return null;
        }
        return att.getDataHandler();
    }

    @Override
    public Attachment getAttachmentObject(String id) {
        return this.getAttachmentObjects().get(id);
    }

    @Override
    public Set<String> getAttachmentNames() {
        if (this.attachmentObjects == null) {
            this.attachmentObjects = this.createAttachments();
        }
        return this.attachmentObjects.keySet();
    }

    @Override
    public void removeAttachment(String id) {
        if (this.attachmentObjects != null && this.attachmentObjects.containsKey(id)) {
            this.attachmentObjects.remove(id);
        }
    }

    @Override
    public Map<String, DataHandler> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new AttachmentMap(this.getAttachmentObjects());
        }
        return this.attachments;
    }

    @Override
    public Map<String, Attachment> getAttachmentObjects() {
        if (this.attachmentObjects == null) {
            this.attachmentObjects = this.createAttachments();
        }
        return this.attachmentObjects;
    }

    @Override
    public void setAttachments(Map<String, DataHandler> attachments) {
        if (attachments == null) {
            this.attachmentObjects = null;
        } else if (attachments instanceof AttachmentMap) {
            this.attachmentObjects = ((AttachmentMap)attachments).getOriginalMap();
        } else {
            this.attachmentObjects = new LinkedHashMap<String, Attachment>();
            for (Map.Entry<String, DataHandler> entry : attachments.entrySet()) {
                this.attachmentObjects.put(entry.getKey(), new DefaultAttachment(entry.getValue()));
            }
        }
        this.attachments = null;
    }

    @Override
    public void setAttachmentObjects(Map<String, Attachment> attachments) {
        this.attachmentObjects = attachments;
        this.attachments = null;
    }

    @Override
    public boolean hasAttachments() {
        return this.attachmentObjects != null && this.attachmentObjects.size() > 0;
    }

    protected boolean hasPopulatedHeaders() {
        return this.headers != null;
    }

    @Override
    public String createExchangeId() {
        return null;
    }

    private static boolean isExcludePatternMatch(String key, String ... excludePatterns) {
        for (String pattern : excludePatterns) {
            if (!EndpointHelper.matchPattern(key, pattern)) continue;
            return true;
        }
        return false;
    }
}

