/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.transport.amqp.AmqpProtocolException;
import org.apache.activemq.transport.amqp.message.AMQPMessageIdHelper;
import org.apache.activemq.transport.amqp.message.EncodedMessage;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.message.Message;

public abstract class InboundTransformer {
    public static final String TRANSFORMER_NATIVE = "native";
    public static final String TRANSFORMER_RAW = "raw";
    public static final String TRANSFORMER_JMS = "jms";

    public abstract String getTransformerName();

    public abstract InboundTransformer getFallbackTransformer();

    public final ActiveMQMessage transform(EncodedMessage amqpMessage) throws Exception {
        ActiveMQMessage message = null;
        for (InboundTransformer transformer = this; transformer != null; transformer = transformer.getFallbackTransformer()) {
            try {
                message = transformer.doTransform(amqpMessage);
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
        if (message == null) {
            throw new AmqpProtocolException("Failed to transform incoming delivery, skipping.", false);
        }
        return message;
    }

    protected abstract ActiveMQMessage doTransform(EncodedMessage var1) throws Exception;

    protected void populateMessage(ActiveMQMessage jms, Message amqp) throws Exception {
        Footer footer;
        Properties properties;
        ApplicationProperties ap;
        MessageAnnotations ma;
        Header header = amqp.getHeader();
        if (header != null) {
            jms.setBooleanProperty("JMS_AMQP_HEADER", true);
            if (header.getDurable() != null) {
                jms.setPersistent(header.getDurable());
            }
            if (header.getPriority() != null) {
                jms.setJMSPriority(header.getPriority().intValue());
            } else {
                jms.setPriority((byte)4);
            }
            if (header.getFirstAcquirer() != null) {
                jms.setBooleanProperty("JMS_AMQP_FirstAcquirer", header.getFirstAcquirer());
            }
            if (header.getDeliveryCount() != null) {
                jms.setRedeliveryCounter(header.getDeliveryCount().intValue());
            }
        } else {
            jms.setPriority((byte)4);
            jms.setPersistent(false);
        }
        if ((ma = amqp.getMessageAnnotations()) != null) {
            for (Map.Entry entry : ma.getValue().entrySet()) {
                String cronEntry;
                String string = entry.getKey().toString();
                if ("x-opt-delivery-time".equals(string) && entry.getValue() != null) {
                    long deliveryTime = ((Number)entry.getValue()).longValue();
                    long delay = deliveryTime - System.currentTimeMillis();
                    if (delay > 0L) {
                        jms.setLongProperty("AMQ_SCHEDULED_DELAY", delay);
                    }
                } else if ("x-opt-delivery-delay".equals(string) && entry.getValue() != null) {
                    long delay = ((Number)entry.getValue()).longValue();
                    if (delay > 0L) {
                        jms.setLongProperty("AMQ_SCHEDULED_DELAY", delay);
                    }
                } else if ("x-opt-delivery-repeat".equals(string) && entry.getValue() != null) {
                    int repeat = ((Number)entry.getValue()).intValue();
                    if (repeat > 0) {
                        jms.setIntProperty("AMQ_SCHEDULED_REPEAT", repeat);
                    }
                } else if ("x-opt-delivery-period".equals(string) && entry.getValue() != null) {
                    long period = ((Number)entry.getValue()).longValue();
                    if (period > 0L) {
                        jms.setLongProperty("AMQ_SCHEDULED_PERIOD", period);
                    }
                } else if ("x-opt-delivery-cron".equals(string) && entry.getValue() != null && (cronEntry = (String)entry.getValue()) != null) {
                    jms.setStringProperty("AMQ_SCHEDULED_CRON", cronEntry);
                }
                this.setProperty(jms, "JMS_AMQP_MA_" + string, entry.getValue());
            }
        }
        if ((ap = amqp.getApplicationProperties()) != null) {
            for (Map.Entry entry : ap.getValue().entrySet()) {
                this.setProperty(jms, entry.getKey().toString(), entry.getValue());
            }
        }
        if ((properties = amqp.getProperties()) != null) {
            Binary binary;
            jms.setBooleanProperty("JMS_AMQP_PROPERTIES", true);
            if (properties.getMessageId() != null) {
                jms.setJMSMessageID(AMQPMessageIdHelper.INSTANCE.toBaseMessageIdString(properties.getMessageId()));
            }
            if ((binary = properties.getUserId()) != null) {
                jms.setUserID(new String(binary.getArray(), binary.getArrayOffset(), binary.getLength(), StandardCharsets.UTF_8));
            }
            if (properties.getTo() != null) {
                jms.setDestination(ActiveMQDestination.createDestination(properties.getTo(), (byte)1));
            }
            if (properties.getSubject() != null) {
                jms.setType(properties.getSubject());
            }
            if (properties.getReplyTo() != null) {
                jms.setReplyTo(ActiveMQDestination.createDestination(properties.getReplyTo(), (byte)1));
            }
            if (properties.getCorrelationId() != null) {
                jms.setCorrelationId(AMQPMessageIdHelper.INSTANCE.toBaseMessageIdString(properties.getCorrelationId()));
            }
            if (properties.getContentType() != null) {
                jms.setStringProperty("JMS_AMQP_ContentType", properties.getContentType().toString());
            }
            if (properties.getContentEncoding() != null) {
                jms.setStringProperty("JMS_AMQP_ContentEncoding", properties.getContentEncoding().toString());
            }
            if (properties.getCreationTime() != null) {
                jms.setTimestamp(properties.getCreationTime().getTime());
            }
            if (properties.getGroupId() != null) {
                jms.setGroupID(properties.getGroupId());
            }
            if (properties.getGroupSequence() != null) {
                jms.setGroupSequence(properties.getGroupSequence().intValue());
            }
            if (properties.getReplyToGroupId() != null) {
                jms.setStringProperty("JMS_AMQP_ReplyToGroupID", properties.getReplyToGroupId());
            }
            if (properties.getAbsoluteExpiryTime() != null) {
                jms.setExpiration(properties.getAbsoluteExpiryTime().getTime());
            }
        }
        if (header != null && jms.getJMSExpiration() == 0L) {
            long l = 0L;
            if (header.getTtl() != null) {
                l = header.getTtl().longValue();
            }
            if (l != 0L) {
                jms.setExpiration(System.currentTimeMillis() + l);
            }
        }
        if ((footer = amqp.getFooter()) != null) {
            for (Map.Entry entry : footer.getValue().entrySet()) {
                String key = entry.getKey().toString();
                this.setProperty(jms, "JMS_AMQP_FT_" + key, entry.getValue());
            }
        }
    }

    private void setProperty(javax.jms.Message msg, String key, Object value) throws JMSException {
        if (value instanceof UnsignedLong) {
            long v = ((UnsignedLong)value).longValue();
            msg.setLongProperty(key, v);
        } else if (value instanceof UnsignedInteger) {
            long v = ((UnsignedInteger)value).longValue();
            if (Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE) {
                msg.setIntProperty(key, (int)v);
            } else {
                msg.setLongProperty(key, v);
            }
        } else if (value instanceof UnsignedShort) {
            int v = ((UnsignedShort)value).intValue();
            if (Short.MIN_VALUE <= v && v <= Short.MAX_VALUE) {
                msg.setShortProperty(key, (short)v);
            } else {
                msg.setIntProperty(key, v);
            }
        } else if (value instanceof UnsignedByte) {
            short v = ((UnsignedByte)value).shortValue();
            if (-128 <= v && v <= 127) {
                msg.setByteProperty(key, (byte)v);
            } else {
                msg.setShortProperty(key, v);
            }
        } else if (value instanceof Symbol) {
            msg.setStringProperty(key, value.toString());
        } else if (value instanceof Decimal128) {
            msg.setDoubleProperty(key, ((Decimal128)value).doubleValue());
        } else if (value instanceof Decimal64) {
            msg.setDoubleProperty(key, ((Decimal64)value).doubleValue());
        } else if (value instanceof Decimal32) {
            msg.setFloatProperty(key, ((Decimal32)value).floatValue());
        } else if (value instanceof Binary) {
            msg.setStringProperty(key, value.toString());
        } else {
            msg.setObjectProperty(key, value);
        }
    }
}

