/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="language,json", title="JSonPath")
@XmlRootElement(name="jsonpath")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JsonPathExpression
extends ExpressionDefinition {
    @XmlAttribute(name="resultType")
    private String resultTypeName;
    @XmlTransient
    private Class<?> resultType;
    @XmlAttribute
    @Metadata(defaultValue="false")
    private Boolean suppressExceptions;

    public JsonPathExpression() {
    }

    public JsonPathExpression(String expression) {
        super(expression);
    }

    public String getResultTypeName() {
        return this.resultTypeName;
    }

    public void setResultTypeName(String resultTypeName) {
        this.resultTypeName = resultTypeName;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public Boolean getSuppressExceptions() {
        return this.suppressExceptions;
    }

    public void setSuppressExceptions(Boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }

    @Override
    public String getLanguage() {
        return "jsonpath";
    }

    @Override
    public Expression createExpression(CamelContext camelContext) {
        if (this.resultType == null && this.resultTypeName != null) {
            try {
                this.resultType = camelContext.getClassResolver().resolveMandatoryClass(this.resultTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return super.createExpression(camelContext);
    }

    @Override
    protected void configureExpression(CamelContext camelContext, Expression expression) {
        if (this.resultType != null) {
            this.setProperty(expression, "resultType", this.resultType);
        }
        if (this.suppressExceptions != null) {
            this.setProperty(expression, "suppressExceptions", this.suppressExceptions);
        }
        super.configureExpression(camelContext, expression);
    }

    @Override
    protected void configurePredicate(CamelContext camelContext, Predicate predicate) {
        if (this.resultType != null) {
            this.setProperty(predicate, "resultType", this.resultType);
        }
        if (this.suppressExceptions != null) {
            this.setProperty(predicate, "suppressExceptions", this.suppressExceptions);
        }
        super.configurePredicate(camelContext, predicate);
    }
}

