/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.parse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.Tool;
import org.antlr.v4.tool.ErrorType;

public class TokenVocabParser {
    protected final Tool tool;
    protected final String vocabName;

    public TokenVocabParser(Tool tool, String vocabName) {
        this.tool = tool;
        this.vocabName = vocabName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map<String, Integer> load() {
        LinkedHashMap<String, Integer> tokens;
        block24: {
            tokens = new LinkedHashMap<String, Integer>();
            int maxTokenType = -1;
            File fullFile = this.getImportedVocabFile();
            FileInputStream fis = null;
            BufferedReader br = null;
            Pattern tokenDefPattern = Pattern.compile("([^\n]+?)[ \\t]*?=[ \\t]*?([0-9]+)");
            fis = new FileInputStream(fullFile);
            InputStreamReader isr = this.tool.grammarEncoding != null ? new InputStreamReader((InputStream)fis, this.tool.grammarEncoding) : new InputStreamReader(fis);
            br = new BufferedReader(isr);
            String tokenDef = br.readLine();
            int lineNum = 1;
            while (tokenDef != null) {
                Matcher matcher = tokenDefPattern.matcher(tokenDef);
                if (matcher.find()) {
                    int tokenType;
                    String tokenID = matcher.group(1);
                    String tokenTypeS = matcher.group(2);
                    try {
                        tokenType = Integer.valueOf(tokenTypeS);
                    }
                    catch (NumberFormatException nfe) {
                        this.tool.errMgr.toolError(ErrorType.TOKENS_FILE_SYNTAX_ERROR, this.vocabName + ".tokens", " bad token type: " + tokenTypeS, lineNum);
                        tokenType = 0;
                    }
                    this.tool.log("grammar", "import " + tokenID + "=" + tokenType);
                    tokens.put(tokenID, tokenType);
                    maxTokenType = Math.max(maxTokenType, tokenType);
                    ++lineNum;
                } else if (tokenDef.length() > 0) {
                    this.tool.errMgr.toolError(ErrorType.TOKENS_FILE_SYNTAX_ERROR, this.vocabName + ".tokens", " bad token def: " + tokenDef, lineNum);
                }
                tokenDef = br.readLine();
            }
            try {
                if (br != null) {
                    br.close();
                }
                break block24;
            }
            catch (IOException ioe) {
                this.tool.errMgr.toolError(ErrorType.ERROR_READING_TOKENS_FILE, fullFile, ioe);
            }
            break block24;
            catch (FileNotFoundException fnfe) {
                this.tool.errMgr.toolError(ErrorType.CANNOT_FIND_TOKENS_FILE, fullFile);
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ioe) {
                    this.tool.errMgr.toolError(ErrorType.ERROR_READING_TOKENS_FILE, fullFile, ioe);
                }
            }
            catch (Exception e) {
                this.tool.errMgr.toolError(ErrorType.ERROR_READING_TOKENS_FILE, fullFile, e);
                {
                    catch (Throwable throwable) {
                        try {
                            if (br != null) {
                                br.close();
                            }
                        }
                        catch (IOException ioe) {
                            this.tool.errMgr.toolError(ErrorType.ERROR_READING_TOKENS_FILE, fullFile, ioe);
                        }
                        throw throwable;
                    }
                }
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ioe) {
                    this.tool.errMgr.toolError(ErrorType.ERROR_READING_TOKENS_FILE, fullFile, ioe);
                }
            }
        }
        return tokens;
    }

    public File getImportedVocabFile() {
        File f = new File(this.tool.libDirectory, File.separator + this.vocabName + ".tokens");
        if (f.exists()) {
            return f;
        }
        f = new File(this.tool.outputDirectory, this.vocabName + ".tokens");
        return f;
    }
}

