/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker;

import alluxio.util.executor.ExecutorServiceFactory;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.Worker;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractWorker
implements Worker {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWorker.class);
    private static final long SHUTDOWN_TIMEOUT_MS = 10000L;
    private final ExecutorServiceFactory mExecutorServiceFactory;
    private ExecutorService mExecutorService;

    protected AbstractWorker(ExecutorServiceFactory executorServiceFactory) {
        this.mExecutorServiceFactory = (ExecutorServiceFactory)Preconditions.checkNotNull((Object)executorServiceFactory, (Object)"executorServiceFactory");
    }

    protected ExecutorService getExecutorService() {
        return this.mExecutorService;
    }

    public void start(WorkerNetAddress address) throws IOException {
        Preconditions.checkState((this.mExecutorService == null ? 1 : 0) != 0);
        this.mExecutorService = this.mExecutorServiceFactory.create();
    }

    public void stop() throws IOException {
        if (this.mExecutorService != null) {
            try {
                this.mExecutorService.shutdownNow();
                String awaitFailureMessage = "waiting for {} executor service to shut down. Daemons may still be running";
                try {
                    if (!this.mExecutorService.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        LOG.warn("Timed out " + awaitFailureMessage, (Object)this.getClass().getSimpleName());
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.warn("Interrupted while " + awaitFailureMessage, (Object)this.getClass().getSimpleName());
                }
            }
            finally {
                this.mExecutorService = null;
            }
        }
    }

    public void close() throws IOException {
        this.stop();
    }
}

