/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.metrics.MetricsSystem;
import alluxio.metrics.sink.MetricsServlet;
import alluxio.metrics.sink.PrometheusMetricsServlet;
import alluxio.web.StacksServlet;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class WebServer {
    private static final Logger LOG = LoggerFactory.getLogger(WebServer.class);
    private static final String DISABLED_METHODS = "TRACE,OPTIONS";
    private static final String THREAD_DUMP_PATH = "/api/v1/common/thread_dump";
    private final Server mServer;
    private final String mServiceName;
    private final InetSocketAddress mAddress;
    private final ServerConnector mServerConnector;
    private final ConstraintSecurityHandler mSecurityHandler;
    protected final ServletContextHandler mServletContextHandler;
    private final MetricsServlet mMetricsServlet = new MetricsServlet(MetricsSystem.METRIC_REGISTRY);
    private final PrometheusMetricsServlet mPMetricsServlet = new PrometheusMetricsServlet(MetricsSystem.METRIC_REGISTRY);

    public WebServer(String serviceName, InetSocketAddress address) {
        Preconditions.checkNotNull((Object)serviceName, (Object)"Service name cannot be null");
        Preconditions.checkNotNull((Object)address, (Object)"Server address cannot be null");
        this.mAddress = address;
        this.mServiceName = serviceName;
        QueuedThreadPool threadPool = new QueuedThreadPool();
        int webThreadCount = ServerConfiguration.getInt(PropertyKey.WEB_THREADS);
        threadPool.setMinThreads(webThreadCount * 2 + 1);
        threadPool.setMaxThreads(webThreadCount * 2 + 100);
        this.mServer = new Server((ThreadPool)threadPool);
        this.mServerConnector = new ServerConnector(this.mServer);
        this.mServerConnector.setPort(this.mAddress.getPort());
        this.mServerConnector.setHost(this.mAddress.getAddress().getHostAddress());
        this.mServerConnector.setReuseAddress(true);
        this.mServer.addConnector((Connector)this.mServerConnector);
        try {
            this.mServerConnector.open();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to listen on address %s for web server %s", this.mAddress, this.mServiceName), e);
        }
        System.setProperty("org.apache.jasper.compiler.disablejsr199", "false");
        this.mServletContextHandler = new ServletContextHandler(2);
        this.mServletContextHandler.setContextPath("/");
        this.mSecurityHandler = (ConstraintSecurityHandler)this.mServletContextHandler.getSecurityHandler();
        for (String s : DISABLED_METHODS.split(",")) {
            this.disableMethod(s);
        }
        this.mServletContextHandler.addServlet(StacksServlet.class, THREAD_DUMP_PATH);
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{this.mMetricsServlet.getHandler(), this.mPMetricsServlet.getHandler(), this.mServletContextHandler, new DefaultHandler()});
        this.mServer.setHandler((Handler)handlers);
    }

    public void addHandler(AbstractHandler handler) {
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)handler);
        for (Handler h : this.mServer.getHandlers()) {
            handlers.addHandler(h);
        }
        this.mServer.setHandler((Handler)handlers);
    }

    public void setHandler(AbstractHandler handler) {
        this.mServer.setHandler((Handler)handler);
    }

    private void disableMethod(String method) {
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(true);
        constraint.setName("Disable " + method);
        ConstraintMapping disableMapping = new ConstraintMapping();
        disableMapping.setConstraint(constraint);
        disableMapping.setMethod(method.toUpperCase());
        disableMapping.setPathSpec("/");
        this.mSecurityHandler.addConstraintMapping(disableMapping);
    }

    public Server getServer() {
        return this.mServer;
    }

    public String getBindHost() {
        String bindHost = this.mServerConnector.getHost();
        return bindHost == null ? "0.0.0.0" : bindHost;
    }

    public int getLocalPort() {
        return this.mServerConnector.getLocalPort();
    }

    public void stop() throws Exception {
        for (Connector connector : this.mServer.getConnectors()) {
            connector.stop();
        }
        this.mServer.stop();
    }

    public void start() {
        try {
            LOG.info("{} starting @ {}", (Object)this.mServiceName, (Object)this.mAddress);
            this.mServer.start();
            LOG.info("{} started @ {}", (Object)this.mServiceName, (Object)this.mAddress);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

