/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.IOUtils;

public final class TarUtils {
    public static void writeTarGz(Path dirPath, OutputStream output) throws IOException, InterruptedException {
        GzipCompressorOutputStream zipStream = new GzipCompressorOutputStream(output);
        TarArchiveOutputStream archiveStream = new TarArchiveOutputStream((OutputStream)zipStream);
        try (Stream<Path> stream = Files.walk(dirPath, new FileVisitOption[0]);){
            for (Path subPath : stream.collect(Collectors.toList())) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                File file = subPath.toFile();
                TarArchiveEntry entry = new TarArchiveEntry(file, dirPath.relativize(subPath).toString());
                archiveStream.putArchiveEntry((ArchiveEntry)entry);
                if (file.isFile()) {
                    try (InputStream fileIn = Files.newInputStream(subPath, new OpenOption[0]);){
                        IOUtils.copy((InputStream)fileIn, (OutputStream)archiveStream);
                    }
                }
                archiveStream.closeArchiveEntry();
            }
        }
        archiveStream.finish();
        zipStream.finish();
    }

    public static void readTarGz(Path dirPath, InputStream input) throws IOException {
        TarArchiveEntry entry;
        GzipCompressorInputStream zipStream = new GzipCompressorInputStream(input);
        TarArchiveInputStream archiveStream = new TarArchiveInputStream((InputStream)zipStream);
        while ((entry = (TarArchiveEntry)archiveStream.getNextEntry()) != null) {
            File outputFile = new File(dirPath.toFile(), entry.getName());
            if (entry.isDirectory()) {
                outputFile.mkdirs();
                continue;
            }
            outputFile.getParentFile().mkdirs();
            FileOutputStream fileOut = new FileOutputStream(outputFile);
            Throwable throwable = null;
            try {
                IOUtils.copy((InputStream)archiveStream, (OutputStream)fileOut);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileOut == null) continue;
                if (throwable != null) {
                    try {
                        fileOut.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fileOut.close();
            }
        }
    }

    private TarUtils() {
    }
}

