/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.journal.JournalType;

public final class FeatureUtils {
    public static boolean isEmbeddedJournal() {
        return JournalType.EMBEDDED.toString().equals(ServerConfiguration.get(PropertyKey.MASTER_JOURNAL_TYPE));
    }

    public static boolean isRocks() {
        return "ROCKS".equals(ServerConfiguration.get(PropertyKey.MASTER_METASTORE));
    }

    public static boolean isZookeeperEnabled() {
        return ServerConfiguration.getBoolean(PropertyKey.ZOOKEEPER_ENABLED);
    }

    public static boolean isBackupDelegationEnabled() {
        return ServerConfiguration.getBoolean(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED);
    }

    public static boolean isDailyBackupEnabled() {
        return ServerConfiguration.getBoolean(PropertyKey.MASTER_DAILY_BACKUP_ENABLED);
    }

    public static boolean isPersistenceBlacklistEmpty() {
        return !ServerConfiguration.isSet(PropertyKey.MASTER_PERSISTENCE_BLACKLIST) || ServerConfiguration.get(PropertyKey.MASTER_PERSISTENCE_BLACKLIST).isEmpty();
    }

    public static boolean isUnsafeDirectPersistEnabled() {
        return ServerConfiguration.getBoolean(PropertyKey.MASTER_UNSAFE_DIRECT_PERSIST_OBJECT_ENABLED);
    }

    public static boolean isMasterAuditLoggingEnabled() {
        return ServerConfiguration.getBoolean(PropertyKey.MASTER_AUDIT_LOGGING_ENABLED);
    }
}

