/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.AlluxioURI;
import alluxio.concurrent.ManagedBlockingUfsForwarder;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.exception.status.NotFoundException;
import alluxio.exception.status.UnavailableException;
import alluxio.master.journal.ufs.UfsJournal;
import alluxio.underfs.UfsManager;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUfsManager
implements UfsManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUfsManager.class);
    private final Object mLock = new Object();
    protected final ConcurrentHashMap<Key, UnderFileSystem> mUnderFileSystemMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, UfsManager.UfsClient> mMountIdToUfsInfoMap = new ConcurrentHashMap();
    private UfsManager.UfsClient mRootUfsClient;
    private UfsManager.UfsClient mJournalUfsClient;
    protected final Closer mCloser = Closer.create();

    protected AbstractUfsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnderFileSystem getOrAdd(AlluxioURI ufsUri, UnderFileSystemConfiguration ufsConf) {
        Key key = new Key(ufsUri, ufsConf.getMountSpecificConf());
        UnderFileSystem cachedFs = this.mUnderFileSystemMap.get(key);
        if (cachedFs != null) {
            return cachedFs;
        }
        Object object = this.mLock;
        synchronized (object) {
            cachedFs = this.mUnderFileSystemMap.get(key);
            if (cachedFs != null) {
                return cachedFs;
            }
            UnderFileSystem fs = UnderFileSystem.Factory.create((String)ufsUri.toString(), (UnderFileSystemConfiguration)ufsConf);
            boolean useManagedBlocking = fs.isObjectStorage();
            if (ufsConf.isSet(PropertyKey.MASTER_UFS_MANAGED_BLOCKING_ENABLED)) {
                useManagedBlocking = ufsConf.getBoolean(PropertyKey.MASTER_UFS_MANAGED_BLOCKING_ENABLED);
            }
            if (useManagedBlocking) {
                fs = new ManagedBlockingUfsForwarder(fs);
            }
            if (this.mUnderFileSystemMap.putIfAbsent(key, fs) != null) {
                LOG.warn("UFS already existed in UFS manager");
            }
            this.mCloser.register((Closeable)fs);
            try {
                this.connectUfs(fs);
            }
            catch (IOException e) {
                LOG.warn("Failed to perform initial connect to UFS {}: {}", (Object)ufsUri, (Object)e.toString());
            }
            return fs;
        }
    }

    protected abstract void connectUfs(UnderFileSystem var1) throws IOException;

    @Override
    public void addMount(long mountId, AlluxioURI ufsUri, UnderFileSystemConfiguration ufsConf) {
        Preconditions.checkArgument((mountId != -1L ? 1 : 0) != 0, (Object)"mountId");
        Preconditions.checkNotNull((Object)ufsUri, (Object)"ufsUri");
        Preconditions.checkNotNull((Object)ufsConf, (Object)"ufsConf");
        this.mMountIdToUfsInfoMap.put(mountId, new UfsManager.UfsClient(() -> this.getOrAdd(ufsUri, ufsConf), ufsUri));
    }

    @Override
    public void removeMount(long mountId) {
        Preconditions.checkArgument((mountId != -1L ? 1 : 0) != 0, (Object)"mountId");
        this.mMountIdToUfsInfoMap.remove(mountId);
    }

    @Override
    public UfsManager.UfsClient get(long mountId) throws NotFoundException, UnavailableException {
        UfsManager.UfsClient ufsClient = this.mMountIdToUfsInfoMap.get(mountId);
        if (ufsClient == null) {
            throw new NotFoundException(String.format("Mount Id %d not found in cached mount points", mountId));
        }
        return ufsClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UfsManager.UfsClient getRoot() {
        AbstractUfsManager abstractUfsManager = this;
        synchronized (abstractUfsManager) {
            if (this.mRootUfsClient == null) {
                String rootUri = ServerConfiguration.get(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
                boolean rootReadOnly = ServerConfiguration.getBoolean(PropertyKey.MASTER_MOUNT_TABLE_ROOT_READONLY);
                boolean rootShared = ServerConfiguration.getBoolean(PropertyKey.MASTER_MOUNT_TABLE_ROOT_SHARED);
                Map<String, String> rootConf = ServerConfiguration.getNestedProperties(PropertyKey.MASTER_MOUNT_TABLE_ROOT_OPTION);
                this.addMount(1L, new AlluxioURI(rootUri), UnderFileSystemConfiguration.defaults((AlluxioConfiguration)ServerConfiguration.global()).setReadOnly(rootReadOnly).setShared(rootShared).createMountSpecificConf(rootConf));
                try {
                    this.mRootUfsClient = this.get(1L);
                }
                catch (NotFoundException | UnavailableException e) {
                    throw new RuntimeException("We should never reach here", e);
                }
            }
            return this.mRootUfsClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UfsManager.UfsClient getJournal(URI location) {
        AbstractUfsManager abstractUfsManager = this;
        synchronized (abstractUfsManager) {
            if (this.mJournalUfsClient == null) {
                this.addMount(9223372036854765807L, new AlluxioURI(location.toString()), UfsJournal.getJournalUfsConf());
                try {
                    this.mJournalUfsClient = this.get(9223372036854765807L);
                }
                catch (NotFoundException | UnavailableException e) {
                    throw new RuntimeException("We should never reach here", e);
                }
            }
            return this.mJournalUfsClient;
        }
    }

    @Override
    public void close() throws IOException {
        this.mCloser.close();
    }

    public static class Key {
        private final String mScheme;
        private final String mAuthority;
        private final Map<String, String> mProperties;

        Key(AlluxioURI uri, Map<String, String> properties) {
            this.mScheme = uri.getScheme() == null ? "" : uri.getScheme().toLowerCase();
            this.mAuthority = uri.getAuthority().toString().toLowerCase();
            this.mProperties = properties == null || properties.isEmpty() ? null : properties;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mScheme, this.mAuthority, this.mProperties});
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            Key that = (Key)object;
            return Objects.equal((Object)this.mAuthority, (Object)that.mAuthority) && Objects.equal(this.mProperties, that.mProperties) && Objects.equal((Object)this.mScheme, (Object)that.mScheme);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("authority", (Object)this.mAuthority).add("scheme", (Object)this.mScheme).add("properties", this.mProperties).toString();
        }
    }
}

