/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.sink;

import io.prometheus.client.Collector;
import io.prometheus.client.dropwizard.samplebuilder.DefaultSampleBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatisNameRewriteSampleBuilder
extends DefaultSampleBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RatisNameRewriteSampleBuilder.class);
    private List<Pattern> mFollowerPatterns = new ArrayList<Pattern>();

    protected RatisNameRewriteSampleBuilder() {
        this.mFollowerPatterns.add(Pattern.compile("grpc_log_appender_follower_(.*)_(latency|success|inconsistency).*"));
        this.mFollowerPatterns.add(Pattern.compile("follower_([^_]*)_.*"));
        this.mFollowerPatterns.add(Pattern.compile("([^_]*)_peerCommitIndex"));
    }

    public Collector.MetricFamilySamples.Sample createSample(String dropwizardName, String nameSuffix, List<String> additionalLabelNames, List<String> additionalLabelValues, double value) {
        if (dropwizardName.startsWith("ratis")) {
            ArrayList<String> names = new ArrayList<String>(additionalLabelNames);
            ArrayList<String> values = new ArrayList<String>(additionalLabelValues);
            String name = this.normalizeRatisMetric(dropwizardName, names, values);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Ratis dropwizard {} metrics are converted to {} with tag keys/values {},{}", new Object[]{dropwizardName, name, names, values});
            }
            return super.createSample(name, nameSuffix, names, values, value);
        }
        return super.createSample(dropwizardName, nameSuffix, additionalLabelNames, additionalLabelValues, value);
    }

    protected String normalizeRatisMetric(String dropwizardName, List<String> names, List<String> values) {
        ArrayList<String> nameParts = new ArrayList<String>(Arrays.asList(dropwizardName.split("\\.")));
        if (nameParts.size() > 2) {
            String[] identifiers = ((String)nameParts.get(2)).split("@");
            names.add("instance");
            values.add(identifiers[0]);
            if (identifiers.length > 1) {
                names.add("group");
                values.add(identifiers[1]);
            }
            nameParts.remove(2);
        }
        if (nameParts.size() > 2) {
            for (Pattern pattern : this.mFollowerPatterns) {
                Matcher matcher = pattern.matcher((CharSequence)nameParts.get(2));
                if (!matcher.matches()) continue;
                names.add("follower");
                String followerId = matcher.group(1);
                values.add(followerId);
                nameParts.set(2, ((String)nameParts.get(2)).replace(followerId + "_", ""));
            }
        }
        return Strings.join(nameParts, (char)'.');
    }
}

