/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.sink;

import alluxio.metrics.sink.RatisNameRewriteSampleBuilder;
import com.codahale.metrics.MetricRegistry;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.dropwizard.samplebuilder.SampleBuilder;
import java.util.Map;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.RatisMetricRegistry;

public class RatisDropwizardExports
extends DropwizardExports {
    public RatisDropwizardExports(MetricRegistry registry) {
        super(registry, (SampleBuilder)new RatisNameRewriteSampleBuilder());
    }

    public static void registerRatisMetricReporters(Map<String, RatisDropwizardExports> ratisMetricsMap) {
        MetricRegistries.global().addReporterRegistration(r1 -> RatisDropwizardExports.registerDropwizard(r1, ratisMetricsMap), r2 -> RatisDropwizardExports.deregisterDropwizard(r2, ratisMetricsMap));
    }

    private static void registerDropwizard(RatisMetricRegistry registry, Map<String, RatisDropwizardExports> ratisMetricsMap) {
        RatisDropwizardExports rde = new RatisDropwizardExports(registry.getDropWizardMetricRegistry());
        CollectorRegistry.defaultRegistry.register((Collector)rde);
        String name = registry.getMetricRegistryInfo().getName();
        ratisMetricsMap.putIfAbsent(name, rde);
    }

    private static void deregisterDropwizard(RatisMetricRegistry registry, Map<String, RatisDropwizardExports> ratisMetricsMap) {
        String name = registry.getMetricRegistryInfo().getName();
        Collector c = (Collector)ratisMetricsMap.remove(name);
        if (c != null) {
            CollectorRegistry.defaultRegistry.unregister(c);
        }
    }
}

