/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.sink;

import alluxio.metrics.sink.Sink;
import com.codahale.metrics.MetricRegistry;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.MetricsServlet;
import java.util.Properties;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

@NotThreadSafe
public class PrometheusMetricsServlet
implements Sink {
    private static final String SERVLET_PATH = "/metrics/prometheus";
    private CollectorRegistry mCollectorRegistry = CollectorRegistry.defaultRegistry;

    public PrometheusMetricsServlet(MetricRegistry registry) {
        this.mCollectorRegistry.register((Collector)new DropwizardExports(registry));
    }

    public PrometheusMetricsServlet(Properties properties, MetricRegistry registry) {
        this(registry);
    }

    public ServletContextHandler getHandler() {
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setContextPath(SERVLET_PATH);
        contextHandler.addServlet(new ServletHolder((Servlet)new MetricsServlet(this.mCollectorRegistry)), "/");
        return contextHandler;
    }

    public void start() {
    }

    public void stop() {
    }

    public void report() {
    }
}

