/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.transport;

import alluxio.master.transport.GrpcMessagingContext;
import alluxio.master.transport.Listener;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;

public class Listeners<T>
implements Iterable<Listener<T>> {
    private final List<ListenerHolder> mListeners = new CopyOnWriteArrayList<ListenerHolder>();

    public int size() {
        return this.mListeners.size();
    }

    public Listener<T> add(Consumer<T> listener) {
        Preconditions.checkNotNull(listener, (Object)"listener should not be null");
        ListenerHolder holder = new ListenerHolder(listener, GrpcMessagingContext.currentContext());
        this.mListeners.add(holder);
        return holder;
    }

    public CompletableFuture<Void> accept(T event) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(this.mListeners.size());
        for (ListenerHolder listener : this.mListeners) {
            if (listener.getContext() != null) {
                futures.add(listener.getContext().execute(() -> listener.getListener().accept(event)));
                continue;
            }
            listener.getListener().accept(event);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
    }

    @Override
    public Iterator<Listener<T>> iterator() {
        return this.mListeners.iterator();
    }

    public class ListenerHolder
    implements Listener<T> {
        private final Consumer<T> mListener;
        private final GrpcMessagingContext mContext;

        ListenerHolder(Consumer<T> listener, GrpcMessagingContext context) {
            this.mListener = listener;
            this.mContext = context;
        }

        @Override
        public void accept(T event) {
            if (this.mContext != null) {
                try {
                    this.mContext.executor().execute(() -> this.mListener.accept(event));
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            } else {
                this.mListener.accept(event);
            }
        }

        @Override
        public void close() {
            Listeners.this.mListeners.remove(this);
        }

        private GrpcMessagingContext getContext() {
            return this.mContext;
        }

        private Consumer<T> getListener() {
            return this.mListener;
        }
    }
}

