/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.transport;

import alluxio.conf.AlluxioConfiguration;
import alluxio.master.transport.GrpcMessagingClient;
import alluxio.master.transport.GrpcMessagingProxy;
import alluxio.master.transport.GrpcMessagingServer;
import alluxio.security.user.UserState;
import alluxio.util.ThreadFactoryUtils;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcMessagingTransport {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcMessagingTransport.class);
    private final AlluxioConfiguration mClientConf;
    private final AlluxioConfiguration mServerConf;
    private final UserState mClientUser;
    private final UserState mServerUser;
    private final String mClientType;
    private final List<GrpcMessagingClient> mClients;
    private final List<GrpcMessagingServer> mServers;
    private GrpcMessagingProxy mServerProxy = new GrpcMessagingProxy();
    private final ExecutorService mExecutor;
    private boolean mClosed;

    public GrpcMessagingTransport(AlluxioConfiguration conf, UserState user, String clientType) {
        this(conf, conf, user, user, clientType);
    }

    public GrpcMessagingTransport(AlluxioConfiguration clientConf, AlluxioConfiguration serverConf, UserState clientUser, UserState serverUser, String clientType) {
        this.mClientConf = clientConf;
        this.mServerConf = serverConf;
        this.mClientUser = clientUser;
        this.mServerUser = serverUser;
        this.mClientType = clientType;
        this.mClients = new LinkedList<GrpcMessagingClient>();
        this.mServers = new LinkedList<GrpcMessagingServer>();
        this.mExecutor = Executors.newCachedThreadPool(ThreadFactoryUtils.build((String)"grpc-messaging-transport-worker-%d", (boolean)true));
    }

    public synchronized GrpcMessagingTransport withServerProxy(GrpcMessagingProxy proxy) {
        Preconditions.checkNotNull((Object)proxy, (Object)"Server proxy reference cannot be null.");
        this.mServerProxy = proxy;
        return this;
    }

    public synchronized GrpcMessagingClient client() {
        if (this.mClosed) {
            throw new RuntimeException("Messaging transport closed");
        }
        GrpcMessagingClient client = new GrpcMessagingClient(this.mClientConf, this.mClientUser, this.mExecutor, this.mClientType);
        this.mClients.add(client);
        return client;
    }

    public synchronized GrpcMessagingServer server() {
        if (this.mClosed) {
            throw new RuntimeException("Messaging transport closed");
        }
        GrpcMessagingServer server = new GrpcMessagingServer(this.mServerConf, this.mServerUser, this.mExecutor, this.mServerProxy);
        this.mServers.add(server);
        return server;
    }

    public synchronized void close() {
        if (!this.mClosed) {
            this.mClosed = true;
            ArrayList<CompletableFuture<Void>> clientCloseFutures = new ArrayList<CompletableFuture<Void>>(this.mClients.size());
            for (GrpcMessagingClient grpcMessagingClient : this.mClients) {
                clientCloseFutures.add(grpcMessagingClient.close());
            }
            this.mClients.clear();
            try {
                CompletableFuture.allOf(clientCloseFutures.toArray(new CompletableFuture[0])).get();
            }
            catch (Exception e) {
                LOG.warn("Failed to close messaging transport clients.", (Throwable)e);
            }
            ArrayList<CompletableFuture<Void>> serverCloseFutures = new ArrayList<CompletableFuture<Void>>(this.mServers.size());
            for (GrpcMessagingServer server : this.mServers) {
                serverCloseFutures.add(server.close());
            }
            this.mServers.clear();
            try {
                CompletableFuture.allOf(serverCloseFutures.toArray(new CompletableFuture[0])).get();
            }
            catch (Exception exception) {
                LOG.warn("Failed to close messaging transport servers.", (Throwable)exception);
            }
            this.mExecutor.shutdownNow();
        }
    }
}

