/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.transport;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GrpcServer;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.GrpcServerBuilder;
import alluxio.grpc.GrpcService;
import alluxio.master.transport.GrpcMessagingConnection;
import alluxio.master.transport.GrpcMessagingContext;
import alluxio.master.transport.GrpcMessagingProxy;
import alluxio.master.transport.GrpcMessagingServiceClientHandler;
import alluxio.security.authentication.ClientIpAddressInjector;
import alluxio.security.user.UserState;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcMessagingServer {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcMessagingServer.class);
    private final AlluxioConfiguration mConf;
    private final UserState mUserState;
    private GrpcServer mGrpcServer;
    private CompletableFuture<Void> mListenFuture;
    private final ExecutorService mExecutor;
    private final GrpcMessagingProxy mProxy;

    public GrpcMessagingServer(AlluxioConfiguration conf, UserState userState, ExecutorService executor, GrpcMessagingProxy proxy) {
        this.mConf = conf;
        this.mUserState = userState;
        this.mExecutor = executor;
        this.mProxy = proxy;
    }

    public synchronized CompletableFuture<Void> listen(InetSocketAddress address, Consumer<GrpcMessagingConnection> listener) {
        if (this.mListenFuture != null && !this.mListenFuture.isCompletedExceptionally()) {
            return this.mListenFuture;
        }
        LOG.debug("Opening messaging server for: {}", (Object)address);
        GrpcMessagingContext threadContext = GrpcMessagingContext.currentContextOrThrow();
        this.mListenFuture = CompletableFuture.runAsync(() -> {
            InetSocketAddress bindAddress = address;
            if (this.mProxy.hasProxyFor(address)) {
                bindAddress = this.mProxy.getProxyFor(address);
                LOG.debug("Found proxy: {} for address: {}", (Object)bindAddress, (Object)address);
            }
            LOG.debug("Binding messaging server to: {}", (Object)bindAddress);
            this.mGrpcServer = GrpcServerBuilder.forAddress((GrpcServerAddress)GrpcServerAddress.create((String)bindAddress.getHostString(), (SocketAddress)bindAddress), (AlluxioConfiguration)this.mConf, (UserState)this.mUserState).maxInboundMessageSize((int)this.mConf.getBytes(PropertyKey.MASTER_EMBEDDED_JOURNAL_TRANSPORT_MAX_INBOUND_MESSAGE_SIZE)).addService(new GrpcService(ServerInterceptors.intercept((BindableService)new GrpcMessagingServiceClientHandler(address, listener::accept, threadContext, this.mExecutor, this.mConf.getMs(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT)), (ServerInterceptor[])new ServerInterceptor[]{new ClientIpAddressInjector()}))).build();
            try {
                this.mGrpcServer.start();
                LOG.info("Successfully started messaging server at: {}", (Object)bindAddress);
            }
            catch (IOException e) {
                this.mGrpcServer = null;
                LOG.debug("Failed to create messaging server for: {}.", (Object)address, (Object)e);
                throw new RuntimeException(e);
            }
        }, this.mExecutor);
        return this.mListenFuture;
    }

    public synchronized CompletableFuture<Void> close() {
        if (this.mGrpcServer == null) {
            return CompletableFuture.completedFuture(null);
        }
        LOG.debug("Closing messaging server: {}", (Object)this.mGrpcServer);
        return CompletableFuture.runAsync(() -> {
            try {
                this.mGrpcServer.shutdown();
            }
            catch (Exception e) {
                LOG.warn("Failed to close messaging gRPC server: {}", (Object)this.mGrpcServer);
            }
            finally {
                this.mGrpcServer = null;
            }
        });
    }
}

