/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.transport;

import alluxio.master.transport.GrpcMessagingThread;
import alluxio.master.transport.GrpcMessagingThreadFactory;
import com.google.common.base.Preconditions;
import io.atomix.catalyst.serializer.Serializer;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.http.concurrent.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcMessagingContext {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcMessagingContext.class);
    private final ScheduledExecutorService mExecutor;
    private final Serializer mSerializer;
    private final Executor mWrappedExecutor = new Executor(){

        @Override
        public void execute(Runnable command) {
            try {
                GrpcMessagingContext.this.mExecutor.execute(GrpcMessagingContext.this.logFailure(command));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    };

    public GrpcMessagingContext(String nameFormat, Serializer serializer) {
        this(new GrpcMessagingThreadFactory(nameFormat), serializer);
    }

    public GrpcMessagingContext(GrpcMessagingThreadFactory factory, Serializer serializer) {
        this(new ScheduledThreadPoolExecutor(1, factory), serializer);
    }

    public GrpcMessagingContext(ScheduledExecutorService executor, Serializer serializer) {
        this(GrpcMessagingContext.getThread(executor), executor, serializer);
    }

    public GrpcMessagingContext(Thread thread, ScheduledExecutorService executor, Serializer serializer) {
        this.mExecutor = executor;
        this.mSerializer = serializer;
        Preconditions.checkState((boolean)(thread instanceof GrpcMessagingThread), (Object)"not a Grpc messaging thread");
        ((GrpcMessagingThread)thread).setContext(this);
    }

    protected static GrpcMessagingThread getThread(ExecutorService executor) {
        AtomicReference thread = new AtomicReference();
        try {
            executor.submit(() -> thread.set((GrpcMessagingThread)Thread.currentThread())).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Failed to initialize thread state", e);
        }
        return (GrpcMessagingThread)thread.get();
    }

    public Serializer serializer() {
        return this.mSerializer;
    }

    public Executor executor() {
        return this.mWrappedExecutor;
    }

    public Cancellable schedule(Duration delay, Runnable runnable) {
        ScheduledFuture<?> future = this.mExecutor.schedule(this.logFailure(runnable), delay.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(false);
    }

    public Cancellable schedule(Duration delay, Duration interval, Runnable runnable) {
        ScheduledFuture<?> future = this.mExecutor.scheduleAtFixedRate(this.logFailure(runnable), delay.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(false);
    }

    public void close() {
        this.mExecutor.shutdownNow();
    }

    public CompletableFuture<Void> execute(Runnable callback) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor().execute(() -> {
            try {
                callback.run();
                future.complete(null);
            }
            catch (Throwable var3) {
                future.completeExceptionally(var3);
            }
        });
        return future;
    }

    public <T> CompletableFuture<T> execute(Supplier<T> callback) {
        CompletableFuture future = new CompletableFuture();
        this.executor().execute(() -> {
            try {
                future.complete(callback.get());
            }
            catch (Throwable var3) {
                future.completeExceptionally(var3);
            }
        });
        return future;
    }

    static GrpcMessagingContext currentContext() {
        Thread thread = Thread.currentThread();
        return thread instanceof GrpcMessagingThread ? ((GrpcMessagingThread)thread).getContext() : null;
    }

    static GrpcMessagingContext currentContextOrThrow() {
        GrpcMessagingContext context = GrpcMessagingContext.currentContext();
        Preconditions.checkNotNull((Object)context, (Object)"not on a Grpc messaging thread");
        return context;
    }

    Runnable logFailure(Runnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                if (!(t instanceof RejectedExecutionException)) {
                    LOG.error("An uncaught exception occurred", t);
                }
                throw t;
            }
        };
    }
}

