/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.transport;

import alluxio.grpc.GrpcChannel;
import alluxio.master.transport.GrpcMessagingConnection;
import alluxio.master.transport.GrpcMessagingContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcMessagingClientConnection
extends GrpcMessagingConnection {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcMessagingClientConnection.class);
    private final GrpcChannel mChannel;

    public GrpcMessagingClientConnection(GrpcMessagingContext context, ExecutorService executor, GrpcChannel channel, long requestTimeoutMs) {
        super(GrpcMessagingConnection.ConnectionOwner.CLIENT, channel.toStringShort(), context, executor, requestTimeoutMs);
        this.mChannel = channel;
    }

    @Override
    public CompletableFuture<Void> close() {
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        super.close().whenComplete((result, error) -> {
            try {
                this.mChannel.shutdown();
            }
            catch (Exception e) {
                LOG.warn("Failed to close channel: {}. Error: {}", (Object)this.mChannel.toStringShort(), (Object)e);
            }
            finally {
                resultFuture.complete(null);
            }
        });
        return resultFuture;
    }
}

