/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.transport;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GrpcChannel;
import alluxio.grpc.GrpcChannelBuilder;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.MessagingServiceGrpc;
import alluxio.grpc.TransportMessage;
import alluxio.master.transport.GrpcMessagingClientConnection;
import alluxio.master.transport.GrpcMessagingConnection;
import alluxio.master.transport.GrpcMessagingContext;
import alluxio.security.user.UserState;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcMessagingClient {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcMessagingClient.class);
    private final AlluxioConfiguration mConf;
    private final UserState mUserState;
    private final ExecutorService mExecutor;
    private final String mClientType;

    public GrpcMessagingClient(AlluxioConfiguration conf, UserState userState, ExecutorService executor, String clientType) {
        this.mConf = conf;
        this.mUserState = userState;
        this.mExecutor = executor;
        this.mClientType = clientType;
    }

    public CompletableFuture<GrpcMessagingConnection> connect(InetSocketAddress address) {
        LOG.debug("Creating a messaging client connection to: {}", (Object)address);
        GrpcMessagingContext threadContext = GrpcMessagingContext.currentContextOrThrow();
        CompletableFuture<GrpcMessagingConnection> connectionFuture = new CompletableFuture<GrpcMessagingConnection>();
        CompletableFuture<GrpcMessagingConnection> buildFuture = CompletableFuture.supplyAsync(() -> {
            try {
                GrpcChannel channel = GrpcChannelBuilder.newBuilder((GrpcServerAddress)GrpcServerAddress.create((String)address.getHostString(), (SocketAddress)address), (AlluxioConfiguration)this.mConf).setClientType(this.mClientType).setSubject(this.mUserState.getSubject()).build();
                MessagingServiceGrpc.MessagingServiceStub messageClientStub = MessagingServiceGrpc.newStub((Channel)channel);
                GrpcMessagingClientConnection clientConnection = new GrpcMessagingClientConnection(threadContext, this.mExecutor, channel, this.mConf.getMs(PropertyKey.MASTER_EMBEDDED_JOURNAL_TRANSPORT_REQUEST_TIMEOUT_MS));
                clientConnection.setTargetObserver((StreamObserver<TransportMessage>)messageClientStub.connect((StreamObserver)clientConnection));
                LOG.debug("Created a messaging client connection: {}", (Object)clientConnection);
                return clientConnection;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, this.mExecutor);
        buildFuture.whenComplete((result, error) -> threadContext.execute(() -> {
            if (error == null) {
                connectionFuture.complete((GrpcMessagingConnection)result);
            } else {
                connectionFuture.completeExceptionally((Throwable)error);
            }
        }));
        return connectionFuture;
    }

    public CompletableFuture<Void> close() {
        LOG.debug("Closing messaging client; {}", (Object)this);
        return CompletableFuture.completedFuture(null);
    }
}

