/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journalv0.ufs;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.journalv0.JournalWriter;
import alluxio.master.journalv0.MutableJournal;
import alluxio.master.journalv0.ufs.UfsJournal;
import alluxio.master.journalv0.ufs.UfsJournalWriter;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.options.DeleteOptions;
import alluxio.util.URIUtils;
import alluxio.util.UnderFileSystemUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class UfsMutableJournal
extends UfsJournal
implements MutableJournal {
    private static final Logger LOG = LoggerFactory.getLogger(UfsMutableJournal.class);

    public UfsMutableJournal(URI location) {
        super(location);
    }

    @Override
    public void format() throws IOException {
        LOG.info("Formatting {}", (Object)this.mLocation);
        try (UnderFileSystem ufs = UnderFileSystem.Factory.create((String)this.mLocation.toString(), (UnderFileSystemConfiguration)UnderFileSystemConfiguration.defaults((AlluxioConfiguration)ServerConfiguration.global()));){
            if (ufs.isDirectory(this.mLocation.toString())) {
                for (UfsStatus p : ufs.listStatus(this.mLocation.toString())) {
                    boolean failedToDelete;
                    URI childPath;
                    try {
                        childPath = URIUtils.appendPath((URI)this.mLocation, (String)p.getName());
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                    if (p.isDirectory()) {
                        failedToDelete = !ufs.deleteDirectory(childPath.toString(), DeleteOptions.defaults().setRecursive(true));
                    } else {
                        boolean bl = failedToDelete = !ufs.deleteFile(childPath.toString());
                    }
                    if (!failedToDelete) continue;
                    throw new IOException(String.format("Failed to delete %s", childPath));
                }
            } else if (!ufs.mkdirs(this.mLocation.toString())) {
                throw new IOException(String.format("Failed to create %s", this.mLocation));
            }
            try {
                UnderFileSystemUtils.touch((UnderFileSystem)ufs, (String)URIUtils.appendPath((URI)this.mLocation, (String)(ServerConfiguration.get(PropertyKey.MASTER_FORMAT_FILE_PREFIX) + System.currentTimeMillis())).toString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    @Override
    public JournalWriter getWriter() {
        return new UfsJournalWriter(this);
    }
}

