/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journalv0.ufs;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.ServerConfiguration;
import alluxio.master.journalv0.JournalInputStream;
import alluxio.master.journalv0.JournalReader;
import alluxio.master.journalv0.ufs.UfsJournal;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class UfsJournalReader
implements JournalReader {
    private static final Logger LOG = LoggerFactory.getLogger(UfsJournalReader.class);
    private final UfsJournal mJournal;
    private final UnderFileSystem mUfs;
    private final URI mCheckpoint;
    private boolean mCheckpointRead = false;
    private long mCheckpointOpenedTime = -1L;
    private long mCheckpointLastModifiedTime = -1L;
    private long mCurrentLogNumber = 1L;

    UfsJournalReader(UfsJournal journal) {
        this.mJournal = (UfsJournal)Preconditions.checkNotNull((Object)journal, (Object)"journal");
        this.mUfs = UnderFileSystem.Factory.create((String)this.mJournal.getLocation().toString(), (UnderFileSystemConfiguration)UnderFileSystemConfiguration.defaults((AlluxioConfiguration)ServerConfiguration.global()));
        this.mCheckpoint = this.mJournal.getCheckpoint();
    }

    @Override
    public boolean isValid() {
        return this.mCheckpointRead && this.mCheckpointOpenedTime == this.mCheckpointLastModifiedTime;
    }

    @Override
    public JournalInputStream getCheckpointInputStream() throws IOException {
        if (this.mCheckpointRead) {
            throw new IOException("Checkpoint file has already been read.");
        }
        this.mCheckpointOpenedTime = this.getCheckpointLastModifiedTimeMs();
        LOG.info("Opening journal checkpoint file: {}", (Object)this.mCheckpoint);
        JournalInputStream jis = this.mJournal.getJournalFormatter().deserialize(this.mUfs.open(this.mCheckpoint.toString()));
        this.mCheckpointRead = true;
        return jis;
    }

    @Override
    public JournalInputStream getNextInputStream() throws IOException {
        if (!this.mCheckpointRead) {
            throw new IOException("Must read the checkpoint file before getting input stream.");
        }
        if (this.getCheckpointLastModifiedTimeMs() != this.mCheckpointOpenedTime) {
            throw new IOException("Checkpoint file has been updated. This reader is no longer valid.");
        }
        URI currentLog = this.mJournal.getCompletedLog(this.mCurrentLogNumber);
        if (!this.mUfs.isFile(currentLog.toString())) {
            LOG.debug("Journal log file: {} does not exist yet.", (Object)currentLog);
            return null;
        }
        LOG.info("Opening journal log file: {}", (Object)currentLog);
        JournalInputStream jis = this.mJournal.getJournalFormatter().deserialize(this.mUfs.open(currentLog.toString()));
        ++this.mCurrentLogNumber;
        return jis;
    }

    @Override
    public long getCheckpointLastModifiedTimeMs() throws IOException {
        if (!this.mUfs.isFile(this.mCheckpoint.toString())) {
            throw new IOException("Checkpoint file " + this.mCheckpoint + " does not exist.");
        }
        Long lastModifiedTime = this.mUfs.getFileStatus(this.mCheckpoint.toString()).getLastModifiedTime();
        if (lastModifiedTime == null) {
            throw new IOException("Failed to get checkpoint file " + this.mCheckpoint + " last modified time.");
        }
        this.mCheckpointLastModifiedTime = lastModifiedTime;
        return this.mCheckpointLastModifiedTime;
    }
}

