/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journalv0.ufs;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.journalv0.Journal;
import alluxio.master.journalv0.JournalFormatter;
import alluxio.master.journalv0.JournalReader;
import alluxio.master.journalv0.ufs.UfsJournalReader;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.util.URIUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class UfsJournal
implements Journal {
    protected static final long FIRST_COMPLETED_LOG_NUMBER = 1L;
    private static final String COMPLETED_LOCATION = "completed";
    private static final String CURRENT_LOG_EXTENSION = ".out";
    private static final String CHECKPOINT_FILENAME = "checkpoint.data";
    private static final String ENTRY_LOG_FILENAME_BASE = "log";
    protected final URI mLocation;
    private final JournalFormatter mJournalFormatter;

    public UfsJournal(URI location) {
        this.mLocation = location;
        this.mJournalFormatter = JournalFormatter.Factory.create();
    }

    public URI getCompletedLocation() {
        try {
            return URIUtils.appendPath((URI)this.mLocation, (String)COMPLETED_LOCATION);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected URI getCheckpoint() {
        try {
            return URIUtils.appendPath((URI)this.mLocation, (String)CHECKPOINT_FILENAME);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getCurrentLog() {
        try {
            return URIUtils.appendPath((URI)this.mLocation, (String)"log.out");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected URI getCompletedLog(long logNumber) {
        try {
            return URIUtils.appendPath((URI)this.getCompletedLocation(), (String)String.format("%s.%020d", ENTRY_LOG_FILENAME_BASE, logNumber));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected JournalFormatter getJournalFormatter() {
        return this.mJournalFormatter;
    }

    @Override
    public URI getLocation() {
        return this.mLocation;
    }

    @Override
    public JournalReader getReader() {
        return new UfsJournalReader(this);
    }

    @Override
    public boolean isFormatted() throws IOException {
        UfsStatus[] files;
        UfsStatus[] ufsStatusArray = null;
        try (UnderFileSystem ufs = UnderFileSystem.Factory.create((String)this.mLocation.toString(), (UnderFileSystemConfiguration)UnderFileSystemConfiguration.defaults((AlluxioConfiguration)ServerConfiguration.global()));){
            files = ufs.listStatus(this.mLocation.toString());
        }
        catch (Throwable object) {
            ufsStatusArray = object;
            throw object;
        }
        if (files == null) {
            return false;
        }
        String formatFilePrefix = ServerConfiguration.get(PropertyKey.MASTER_FORMAT_FILE_PREFIX);
        for (UfsStatus file : files) {
            if (!file.getName().startsWith(formatFilePrefix)) continue;
            return true;
        }
        return false;
    }
}

