/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journalv0.ufs;

import alluxio.master.journalv0.ufs.UfsJournalWriter;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.UnderFileSystemUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UfsCheckpointManager {
    private static final Logger LOG = LoggerFactory.getLogger(UfsCheckpointManager.class);
    private final UnderFileSystem mUfs;
    private final URI mCheckpoint;
    private final URI mBackupCheckpoint;
    private final URI mTempBackupCheckpoint;
    private final UfsJournalWriter mWriter;

    public UfsCheckpointManager(UnderFileSystem ufs, URI checkpoint, UfsJournalWriter writer) {
        this.mUfs = ufs;
        this.mCheckpoint = checkpoint;
        try {
            this.mBackupCheckpoint = new URI(this.mCheckpoint + ".backup");
            this.mTempBackupCheckpoint = new URI(this.mBackupCheckpoint + ".tmp");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.mWriter = writer;
    }

    public void recover() {
        try {
            boolean checkpointExists = this.mUfs.isFile(this.mCheckpoint.toString());
            boolean backupCheckpointExists = this.mUfs.isFile(this.mBackupCheckpoint.toString());
            boolean tempBackupCheckpointExists = this.mUfs.isFile(this.mTempBackupCheckpoint.toString());
            Preconditions.checkState((!checkpointExists || !backupCheckpointExists || !tempBackupCheckpointExists ? 1 : 0) != 0, (Object)"checkpoint, temp backup checkpoint, and backup checkpoint should never all exist ");
            if (tempBackupCheckpointExists) {
                UnderFileSystemUtils.deleteFileIfExists((UnderFileSystem)this.mUfs, (String)this.mCheckpoint.toString());
                this.mUfs.renameFile(this.mTempBackupCheckpoint.toString(), this.mCheckpoint.toString());
            }
            if (backupCheckpointExists) {
                if (checkpointExists) {
                    this.mWriter.deleteCompletedLogs();
                    this.mUfs.deleteFile(this.mBackupCheckpoint.toString());
                } else {
                    this.mUfs.renameFile(this.mBackupCheckpoint.toString(), this.mCheckpoint.toString());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void update(URI location) {
        try {
            if (this.mUfs.isFile(this.mCheckpoint.toString())) {
                UnderFileSystemUtils.deleteFileIfExists((UnderFileSystem)this.mUfs, (String)this.mTempBackupCheckpoint.toString());
                UnderFileSystemUtils.deleteFileIfExists((UnderFileSystem)this.mUfs, (String)this.mBackupCheckpoint.toString());
                this.mUfs.renameFile(this.mCheckpoint.toString(), this.mTempBackupCheckpoint.toString());
                this.mUfs.renameFile(this.mTempBackupCheckpoint.toString(), this.mBackupCheckpoint.toString());
                LOG.info("Backed up the checkpoint file to {}", (Object)this.mBackupCheckpoint.toString());
            }
            this.mUfs.renameFile(location.getPath(), this.mCheckpoint.toString());
            LOG.info("Renamed the checkpoint file from {} to {}", (Object)location, (Object)this.mCheckpoint.toString());
            this.mWriter.deleteCompletedLogs();
            UnderFileSystemUtils.deleteFileIfExists((UnderFileSystem)this.mUfs, (String)this.mBackupCheckpoint.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

