/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journalv0;

import alluxio.master.journalv0.JournalFormatter;
import alluxio.master.journalv0.JournalInputStream;
import alluxio.proto.journal.Journal;
import alluxio.util.proto.ProtoUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ProtoBufJournalFormatter
implements JournalFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoBufJournalFormatter.class);

    @Override
    public void serialize(Journal.JournalEntry entry, OutputStream outputStream) throws IOException {
        entry.writeDelimitedTo(outputStream);
    }

    @Override
    public JournalInputStream deserialize(final InputStream inputStream) throws IOException {
        return new JournalInputStream(){
            private final byte[] mBuffer = new byte[1024];
            private long mLatestSequenceNumber;

            @Override
            public Journal.JournalEntry read() throws IOException {
                int totalBytesRead;
                int latestBytesRead;
                int firstByte = inputStream.read();
                if (firstByte == -1) {
                    return null;
                }
                int size = ProtoUtils.readRawVarint32((int)firstByte, (InputStream)inputStream);
                byte[] buffer = size <= this.mBuffer.length ? this.mBuffer : new byte[size];
                for (totalBytesRead = 0; totalBytesRead < size && (latestBytesRead = inputStream.read(buffer, totalBytesRead, size - totalBytesRead)) >= 0; totalBytesRead += latestBytesRead) {
                }
                if (totalBytesRead < size) {
                    LOG.warn("Journal entry was truncated. Expected to read " + size + " bytes but only got " + totalBytesRead);
                    return null;
                }
                Journal.JournalEntry entry = Journal.JournalEntry.parseFrom((InputStream)new ByteArrayInputStream(buffer, 0, size));
                if (entry != null) {
                    this.mLatestSequenceNumber = entry.getSequenceNumber();
                }
                return entry;
            }

            @Override
            public void close() throws IOException {
                inputStream.close();
            }

            @Override
            public long getLatestSequenceNumber() {
                return this.mLatestSequenceNumber;
            }
        };
    }
}

