/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journalv0;

import alluxio.master.journalv0.Journal;
import alluxio.master.journalv0.JournalFactory;
import alluxio.master.journalv0.JournalWriter;
import alluxio.master.journalv0.ufs.UfsMutableJournal;
import alluxio.util.URIUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface MutableJournal
extends Journal {
    public void format() throws IOException;

    public JournalWriter getWriter();

    @ThreadSafe
    public static final class Factory
    implements JournalFactory {
        private final URI mBase;

        public Factory(URI base) {
            this.mBase = base;
        }

        @Override
        public MutableJournal create(String name) {
            try {
                return new UfsMutableJournal(URIUtils.appendPath((URI)this.mBase, (String)name));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public static MutableJournal create(URI location) {
            return new UfsMutableJournal(location);
        }
    }
}

