/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journalv0;

import alluxio.master.journalv0.JournalFactory;
import alluxio.master.journalv0.JournalReader;
import alluxio.master.journalv0.ufs.UfsJournal;
import alluxio.util.URIUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Journal {
    public URI getLocation();

    public JournalReader getReader();

    public boolean isFormatted() throws IOException;

    @ThreadSafe
    public static final class Factory
    implements JournalFactory {
        private final URI mBase;

        public Factory(URI base) {
            this.mBase = base;
        }

        @Override
        public Journal create(String name) {
            try {
                return new UfsJournal(URIUtils.appendPath((URI)this.mBase, (String)name));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public static Journal create(URI location) {
            return new UfsJournal(location);
        }
    }
}

