/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journalv0;

import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.journalv0.JournalWriter;
import alluxio.proto.journal.Journal;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class AsyncJournalWriter {
    private final JournalWriter mJournalWriter;
    private final ConcurrentLinkedQueue<Journal.JournalEntry> mQueue;
    private final AtomicLong mCounter;
    private final AtomicLong mFlushCounter;
    private final AtomicLong mWriteCounter;
    private final long mFlushBatchTimeNs;
    private final ReentrantLock mFlushLock = new ReentrantLock(true);

    public AsyncJournalWriter(JournalWriter journalWriter) {
        this.mJournalWriter = (JournalWriter)Preconditions.checkNotNull((Object)journalWriter, (Object)"journalWriter");
        this.mQueue = new ConcurrentLinkedQueue();
        this.mCounter = new AtomicLong(0L);
        this.mFlushCounter = new AtomicLong(0L);
        this.mWriteCounter = new AtomicLong(0L);
        this.mFlushBatchTimeNs = 1000000L * ServerConfiguration.getMs(PropertyKey.MASTER_JOURNAL_FLUSH_BATCH_TIME_MS);
    }

    public long appendEntry(Journal.JournalEntry entry) {
        this.mCounter.incrementAndGet();
        this.mQueue.offer(entry);
        return this.mCounter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(long targetCounter) throws IOException {
        if (targetCounter <= this.mFlushCounter.get()) {
            return;
        }
        this.mFlushLock.lock();
        try {
            long startTime = System.nanoTime();
            long flushCounter = this.mFlushCounter.get();
            if (targetCounter <= flushCounter) {
                return;
            }
            long writeCounter = this.mWriteCounter.get();
            block4: while (targetCounter > writeCounter) {
                Journal.JournalEntry entry;
                while ((entry = this.mQueue.peek()) != null) {
                    this.mJournalWriter.write(entry);
                    this.mQueue.poll();
                    writeCounter = this.mWriteCounter.incrementAndGet();
                    if (writeCounter < targetCounter || System.nanoTime() - startTime < this.mFlushBatchTimeNs) continue;
                    continue block4;
                }
            }
            this.mJournalWriter.flush();
            this.mFlushCounter.set(writeCounter);
        }
        finally {
            this.mFlushLock.unlock();
        }
    }
}

