/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.ufs;

import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.Master;
import alluxio.master.journal.AbstractJournalSystem;
import alluxio.master.journal.CatchupFuture;
import alluxio.master.journal.sink.JournalSink;
import alluxio.master.journal.ufs.UfsJournal;
import alluxio.master.journal.ufs.UfsJournalCheckpointThread;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.retry.ExponentialTimeBoundedRetry;
import alluxio.util.CommonUtils;
import alluxio.util.URIUtils;
import alluxio.util.WaitForOptions;
import com.codahale.metrics.Timer;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class UfsJournalSystem
extends AbstractJournalSystem {
    private static final Logger LOG = LoggerFactory.getLogger(UfsJournalSystem.class);
    private final URI mBase;
    private final long mQuietTimeMs;
    private ConcurrentHashMap<String, UfsJournal> mJournals;
    private long mInitialCatchupTimeMs = -1L;

    public UfsJournalSystem(URI base, long quietTimeMs) {
        this.mBase = base;
        this.mQuietTimeMs = quietTimeMs;
        this.mJournals = new ConcurrentHashMap();
        MetricsSystem.registerGaugeIfAbsent((String)MetricKey.MASTER_UFS_JOURNAL_INITIAL_REPLAY_TIME_MS.getName(), () -> this.mInitialCatchupTimeMs);
        try {
        }
        catch (RuntimeException e) {
            return;
        }
    }

    @Override
    public UfsJournal createJournal(Master master) {
        Supplier<Set<JournalSink>> supplier = () -> this.getJournalSinks(master);
        UfsJournal journal = new UfsJournal(URIUtils.appendPathOrDie((URI)this.mBase, (String)master.getName()), master, this.mQuietTimeMs, supplier);
        this.mJournals.put(master.getName(), journal);
        return journal;
    }

    @Override
    public void gainPrimacy() {
        ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>();
        for (Map.Entry<String, UfsJournal> entry : this.mJournals.entrySet()) {
            callables.add(() -> {
                UfsJournal journal = (UfsJournal)entry.getValue();
                journal.gainPrimacy();
                return null;
            });
        }
        try {
            CommonUtils.invokeAll(callables, (long)31536000000L);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void losePrimacy() {
        for (UfsJournal journal : this.mJournals.values()) {
            journal.signalLosePrimacy();
        }
        try {
            for (UfsJournal journal : this.mJournals.values()) {
                journal.awaitLosePrimacy();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to downgrade journal to standby", e);
        }
    }

    @Override
    public void suspend(Runnable interruptCallback) throws IOException {
        for (Map.Entry<String, UfsJournal> journalEntry : this.mJournals.entrySet()) {
            LOG.info("Suspending journal: {}", (Object)journalEntry.getKey());
            journalEntry.getValue().suspend();
        }
    }

    @Override
    public void resume() throws IOException {
        for (Map.Entry<String, UfsJournal> journalEntry : this.mJournals.entrySet()) {
            LOG.info("Resuming journal: {}", (Object)journalEntry.getKey());
            journalEntry.getValue().resume();
        }
    }

    @Override
    public CatchupFuture catchup(Map<String, Long> journalSequenceNumbers) throws IOException {
        ArrayList<CatchupFuture> futures = new ArrayList<CatchupFuture>(journalSequenceNumbers.size());
        for (Map.Entry<String, UfsJournal> journalEntry : this.mJournals.entrySet()) {
            long resumeSequence = journalSequenceNumbers.get(journalEntry.getKey());
            LOG.info("Advancing journal :{} to sequence: {}", (Object)journalEntry.getKey(), (Object)resumeSequence);
            futures.add(journalEntry.getValue().catchup(resumeSequence));
        }
        return CatchupFuture.allOf(futures);
    }

    @Override
    public void waitForCatchup() {
        long start = System.currentTimeMillis();
        try (Timer.Context ctx = MetricsSystem.timer((String)MetricKey.MASTER_UFS_JOURNAL_CATCHUP_TIMER.getName()).time();){
            CommonUtils.waitFor((String)"journal catch up to finish", () -> {
                for (UfsJournal journal : this.mJournals.values()) {
                    UfsJournalCheckpointThread.CatchupState catchupState = journal.getCatchupState();
                    if (catchupState == UfsJournalCheckpointThread.CatchupState.DONE) continue;
                    return false;
                }
                return true;
            }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs((int)ServerConfiguration.getMs(PropertyKey.MASTER_UFS_JOURNAL_MAX_CATCHUP_TIME)).setInterval(1000));
        }
        catch (InterruptedException | TimeoutException e) {
            LOG.info("Journal catchup is interrupted or timeout", (Throwable)e);
            if (this.mInitialCatchupTimeMs == -1L) {
                this.mInitialCatchupTimeMs = System.currentTimeMillis() - start;
            }
            return;
        }
        if (this.mInitialCatchupTimeMs == -1L) {
            this.mInitialCatchupTimeMs = System.currentTimeMillis() - start;
        }
        LOG.info("Finished master process ufs journal catchup in {} ms", (Object)this.mInitialCatchupTimeMs);
    }

    @Override
    public Map<String, Long> getCurrentSequenceNumbers() {
        HashMap<String, Long> sequenceMap = new HashMap<String, Long>();
        for (String master : this.mJournals.keySet()) {
            sequenceMap.put(master, this.mJournals.get(master).getNextSequenceNumberToWrite() - 1L);
        }
        return sequenceMap;
    }

    @Override
    public void startInternal() throws IOException {
        for (UfsJournal journal : this.mJournals.values()) {
            journal.start();
        }
    }

    @Override
    public void stopInternal() {
        Closer closer = Closer.create();
        for (UfsJournal journal : this.mJournals.values()) {
            closer.register((Closeable)journal);
        }
        ExponentialTimeBoundedRetry retry = ExponentialTimeBoundedRetry.builder().withMaxDuration(Duration.ofMinutes(1L)).withInitialSleep(Duration.ofMillis(100L)).withMaxSleep(Duration.ofSeconds(3L)).build();
        IOException exception = null;
        while (retry.attempt()) {
            try {
                closer.close();
                return;
            }
            catch (IOException e) {
                exception = e;
                LOG.warn("Failed to close journal: {}", (Object)e.toString());
            }
        }
        if (exception != null) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean isFormatted() throws IOException {
        for (UfsJournal journal : this.mJournals.values()) {
            if (journal.isFormatted()) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean isEmpty() {
        for (UfsJournal journal : this.mJournals.values()) {
            if (journal.getNextSequenceNumberToWrite() <= 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public void format() throws IOException {
        for (UfsJournal journal : this.mJournals.values()) {
            journal.format();
        }
    }

    @Override
    public void checkpoint() throws IOException {
        for (UfsJournal journal : this.mJournals.values()) {
            journal.checkpoint();
        }
    }
}

