/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.ufs;

import alluxio.master.journal.ufs.UfsJournal;
import alluxio.master.journal.ufs.UfsJournalFile;
import alluxio.underfs.UfsStatus;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@VisibleForTesting
public final class UfsJournalSnapshot {
    private final List<UfsJournalFile> mCheckpoints;
    private final List<UfsJournalFile> mLogs;
    private final List<UfsJournalFile> mTemporaryCheckpoints;

    private UfsJournalSnapshot(List<UfsJournalFile> checkpoints, List<UfsJournalFile> logs, List<UfsJournalFile> temporaryCheckpoints) {
        this.mCheckpoints = checkpoints;
        this.mLogs = logs;
        this.mTemporaryCheckpoints = temporaryCheckpoints;
    }

    public List<UfsJournalFile> getCheckpoints() {
        return this.mCheckpoints;
    }

    public UfsJournalFile getLatestCheckpoint() {
        if (!this.mCheckpoints.isEmpty()) {
            return this.mCheckpoints.get(this.mCheckpoints.size() - 1);
        }
        return null;
    }

    public List<UfsJournalFile> getLogs() {
        return this.mLogs;
    }

    public List<UfsJournalFile> getTemporaryCheckpoints() {
        return this.mTemporaryCheckpoints;
    }

    public static UfsJournalSnapshot getSnapshot(UfsJournal journal) throws IOException {
        ArrayList<UfsJournalFile> checkpoints = new ArrayList<UfsJournalFile>();
        UfsStatus[] statuses = journal.getUfs().listStatus(journal.getCheckpointDir().toString());
        if (statuses != null) {
            for (UfsStatus status : statuses) {
                UfsJournalFile file = UfsJournalFile.decodeCheckpointFile(journal, status.getName());
                if (file == null) continue;
                checkpoints.add(file);
            }
            Collections.sort(checkpoints);
        }
        ArrayList<UfsJournalFile> logs = new ArrayList<UfsJournalFile>();
        statuses = journal.getUfs().listStatus(journal.getLogDir().toString());
        if (statuses != null) {
            for (UfsStatus status : statuses) {
                UfsJournalFile file = UfsJournalFile.decodeLogFile(journal, status.getName());
                if (file == null) continue;
                logs.add(file);
            }
            Collections.sort(logs);
        }
        ArrayList<UfsJournalFile> tmpCheckpoints = new ArrayList<UfsJournalFile>();
        statuses = journal.getUfs().listStatus(journal.getTmpDir().toString());
        if (statuses != null) {
            for (UfsStatus status : statuses) {
                tmpCheckpoints.add(UfsJournalFile.decodeTemporaryCheckpointFile(journal, status.getName()));
            }
        }
        return new UfsJournalSnapshot(checkpoints, logs, tmpCheckpoints);
    }

    @VisibleForTesting
    public static UfsJournalFile getCurrentLog(UfsJournal journal) throws IOException {
        ArrayList<UfsJournalFile> logs = new ArrayList<UfsJournalFile>();
        UfsStatus[] statuses = journal.getUfs().listStatus(journal.getLogDir().toString());
        if (statuses != null) {
            UfsJournalFile file;
            for (UfsStatus status : statuses) {
                UfsJournalFile file2 = UfsJournalFile.decodeLogFile(journal, status.getName());
                if (file2 == null) continue;
                logs.add(file2);
            }
            if (!logs.isEmpty() && (file = (UfsJournalFile)Collections.max(logs)).isIncompleteLog()) {
                return file;
            }
        }
        return null;
    }

    static long getNextLogSequenceNumberToCheckpoint(UfsJournal journal) throws IOException {
        ArrayList<UfsJournalFile> checkpoints = new ArrayList<UfsJournalFile>();
        UfsStatus[] statuses = journal.getUfs().listStatus(journal.getCheckpointDir().toString());
        if (statuses != null) {
            for (UfsStatus status : statuses) {
                UfsJournalFile file = UfsJournalFile.decodeCheckpointFile(journal, status.getName());
                if (file == null) continue;
                checkpoints.add(file);
            }
            Collections.sort(checkpoints);
        }
        if (checkpoints.isEmpty()) {
            return 0L;
        }
        return ((UfsJournalFile)checkpoints.get(checkpoints.size() - 1)).getEnd();
    }
}

