/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.ufs;

import alluxio.ProcessUtils;
import alluxio.exception.ExceptionMessage;
import alluxio.master.journal.JournalEntryStreamReader;
import alluxio.master.journal.JournalReader;
import alluxio.master.journal.checkpoint.CheckpointInputStream;
import alluxio.master.journal.ufs.UfsJournal;
import alluxio.master.journal.ufs.UfsJournalFile;
import alluxio.master.journal.ufs.UfsJournalSnapshot;
import alluxio.proto.journal.Journal;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.LogUtils;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.OptionalLong;
import java.util.Queue;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class UfsJournalReader
implements JournalReader {
    private static final Logger LOG = LoggerFactory.getLogger(UfsJournalReader.class);
    private final UfsJournal mJournal;
    private final UnderFileSystem mUfs;
    private long mNextSequenceNumber;
    private JournalInputStream mInputStream;
    private final Queue<UfsJournalFile> mFilesToProcess = new ArrayDeque<UfsJournalFile>();
    private final boolean mReadIncompleteLog;
    private boolean mClosed;
    private CheckpointInputStream mCheckpointStream;
    private Journal.JournalEntry mNextEntry;

    UfsJournalReader(UfsJournal journal, boolean readIncompleteLog) {
        this(journal, 0L, readIncompleteLog);
    }

    public UfsJournalReader(UfsJournal journal, long startSequenceId, boolean readIncompleteLog) {
        this.mJournal = (UfsJournal)Preconditions.checkNotNull((Object)journal, (Object)"journal");
        this.mUfs = this.mJournal.getUfs();
        this.mNextSequenceNumber = startSequenceId;
        this.mReadIncompleteLog = readIncompleteLog;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        if (this.mInputStream != null) {
            this.mInputStream.close();
        }
    }

    @Override
    public long getNextSequenceNumber() {
        return this.mNextSequenceNumber;
    }

    @Override
    public CheckpointInputStream getCheckpoint() {
        return (CheckpointInputStream)Preconditions.checkNotNull((Object)this.mCheckpointStream, (Object)"mCheckpointStream");
    }

    @Override
    public Journal.JournalEntry getEntry() {
        Preconditions.checkState((this.mCheckpointStream == null ? 1 : 0) != 0, (Object)"Should not call getEntry() when a checkpoint is available");
        Preconditions.checkNotNull((Object)this.mNextEntry);
        return this.mNextEntry;
    }

    private void advanceEntry() throws IOException {
        Journal.JournalEntry entry;
        while (true) {
            try {
                entry = this.readInternal();
            }
            catch (IOException e) {
                throw new IOException(String.format("Failed to read from journal: %s error: %s", this.mJournal.getLocation(), e.getMessage()), e);
            }
            if (entry == null) {
                return;
            }
            if (entry.getSequenceNumber() == this.mNextSequenceNumber) {
                ++this.mNextSequenceNumber;
                this.mNextEntry = entry;
                return;
            }
            if (entry.getSequenceNumber() >= this.mNextSequenceNumber) break;
            LOG.debug("Skipping duplicate log entry {} (next sequence number: {}).", (Object)entry, (Object)this.mNextSequenceNumber);
        }
        throw new IllegalStateException(ExceptionMessage.JOURNAL_ENTRY_MISSING.getMessage(new Object[]{this.mNextSequenceNumber, entry.getSequenceNumber()}));
    }

    private Journal.JournalEntry readInternal() throws IOException {
        if (this.mInputStream == null) {
            return null;
        }
        Journal.JournalEntry entry = this.mInputStream.mReader.readEntry();
        if (entry != null) {
            return entry;
        }
        if (this.mInputStream.mFile.isIncompleteLog()) {
            return null;
        }
        Preconditions.checkState((boolean)this.mInputStream.mFile.isCompletedLog(), (Object)"Expected log to be either checkpoint, incomplete, or complete");
        ProcessUtils.fatalError(LOG, "Journal entry %s was truncated", this.mNextSequenceNumber);
        return null;
    }

    private void updateInputStream() throws IOException {
        if (this.mInputStream != null && (this.mInputStream.mFile.isIncompleteLog() || !this.mInputStream.isDone(this.mNextSequenceNumber))) {
            return;
        }
        if (this.mInputStream != null) {
            this.mInputStream.close();
            this.mInputStream = null;
        }
        if (this.mFilesToProcess.isEmpty()) {
            UfsJournalSnapshot snapshot = UfsJournalSnapshot.getSnapshot(this.mJournal);
            if (snapshot.getCheckpoints().isEmpty() && snapshot.getLogs().isEmpty()) {
                return;
            }
            int index = 0;
            if (!snapshot.getCheckpoints().isEmpty()) {
                UfsJournalFile file;
                UfsJournalFile checkpoint = snapshot.getLatestCheckpoint();
                if (this.mNextSequenceNumber < checkpoint.getEnd()) {
                    String location = checkpoint.getLocation().toString();
                    LOG.info("Reading checkpoint {}", (Object)location);
                    this.mCheckpointStream = new CheckpointInputStream(this.mUfs.open(location, OpenOptions.defaults().setRecoverFailedOpen(true)));
                    this.mNextSequenceNumber = checkpoint.getEnd();
                }
                while (index < snapshot.getLogs().size() && (file = snapshot.getLogs().get(index)).getEnd() <= checkpoint.getEnd()) {
                    ++index;
                }
            }
            while (index < snapshot.getLogs().size()) {
                UfsJournalFile file = snapshot.getLogs().get(index);
                if ((this.mReadIncompleteLog || !file.isIncompleteLog()) && this.mNextSequenceNumber < file.getEnd()) {
                    this.mFilesToProcess.add(snapshot.getLogs().get(index));
                }
                ++index;
            }
        }
        if (!this.mFilesToProcess.isEmpty()) {
            this.mInputStream = new JournalInputStream(this.mFilesToProcess.poll(), this.mUfs);
        }
    }

    @Override
    public JournalReader.State advance() throws IOException {
        this.mCheckpointStream = null;
        this.mNextEntry = null;
        this.updateInputStream();
        if (this.mCheckpointStream != null) {
            return JournalReader.State.CHECKPOINT;
        }
        this.advanceEntry();
        if (this.mNextEntry != null) {
            return JournalReader.State.LOG;
        }
        return JournalReader.State.DONE;
    }

    public static OptionalLong getLastSN(UfsJournal journal) {
        long endSN = 0L;
        try (UfsJournalReader reader = new UfsJournalReader(journal, 0L, false);){
            reader.updateInputStream();
            while (!reader.mFilesToProcess.isEmpty()) {
                UfsJournalFile file = reader.mFilesToProcess.poll();
                endSN = Math.max(endSN, file.getEnd());
                reader.mInputStream = new JournalInputStream(file, reader.mUfs);
                reader.updateInputStream();
            }
        }
        catch (IOException e) {
            LogUtils.warnWithException((Logger)LOG, (String)"Failed to get last SN from journal", (Object[])new Object[]{e});
            return OptionalLong.empty();
        }
        return OptionalLong.of(endSN);
    }

    private static class JournalInputStream
    implements Closeable {
        final UfsJournalFile mFile;
        final JournalEntryStreamReader mReader;

        JournalInputStream(UfsJournalFile file, UnderFileSystem ufs) throws IOException {
            this.mFile = file;
            LOG.info("Reading journal file {}.", (Object)file.getLocation());
            this.mReader = new JournalEntryStreamReader(ufs.open(file.getLocation().toString(), OpenOptions.defaults().setRecoverFailedOpen(true)));
        }

        boolean isDone(long seqNumber) {
            return this.mFile.getEnd() == seqNumber;
        }

        @Override
        public void close() throws IOException {
            this.mReader.close();
        }
    }
}

