/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.ufs;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.ServerConfiguration;
import alluxio.master.journal.JournalFileParser;
import alluxio.proto.journal.Journal;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.util.proto.ProtoUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class UfsJournalFileParser
implements JournalFileParser {
    private static final Logger LOG = LoggerFactory.getLogger(UfsJournalFileParser.class);
    private final UnderFileSystem mUfs;
    private byte[] mBuffer = new byte[1024];
    private InputStream mInputStream;
    private URI mLocation;

    public UfsJournalFileParser(URI location) {
        this.mLocation = (URI)Preconditions.checkNotNull((Object)location, (Object)"location");
        this.mUfs = UnderFileSystem.Factory.create((String)this.mLocation.toString(), (UnderFileSystemConfiguration)UnderFileSystemConfiguration.defaults((AlluxioConfiguration)ServerConfiguration.global()));
    }

    @Override
    public void close() throws IOException {
        this.mInputStream.close();
    }

    @Override
    public Journal.JournalEntry next() throws IOException {
        int totalBytesRead;
        int latestBytesRead;
        int size;
        int firstByte;
        if (this.mInputStream == null) {
            this.mInputStream = this.mUfs.open(this.mLocation.toString());
        }
        if ((firstByte = this.mInputStream.read()) == -1) {
            return null;
        }
        try {
            size = ProtoUtils.readRawVarint32((int)firstByte, (InputStream)this.mInputStream);
        }
        catch (IOException e) {
            LOG.warn("Journal entry was truncated in the size portion.");
            return null;
        }
        if (size > this.mBuffer.length) {
            this.mBuffer = new byte[size];
        }
        for (totalBytesRead = 0; totalBytesRead < size && (latestBytesRead = this.mInputStream.read(this.mBuffer, totalBytesRead, size - totalBytesRead)) >= 0; totalBytesRead += latestBytesRead) {
        }
        if (totalBytesRead < size) {
            LOG.warn("Journal entry was truncated. Expected to read " + size + " bytes but only got " + totalBytesRead);
            return null;
        }
        return (Journal.JournalEntry)Journal.JournalEntry.parser().parseFrom(this.mBuffer, 0, size);
    }
}

