/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.ufs;

import alluxio.master.journal.ufs.UfsJournal;
import alluxio.util.URIUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@VisibleForTesting
public final class UfsJournalFile
implements Comparable<UfsJournalFile> {
    private static final Logger LOG = LoggerFactory.getLogger(UfsJournalFile.class);
    private final URI mLocation;
    private final long mStart;
    private final long mEnd;
    private final boolean mIsCheckpoint;

    private UfsJournalFile(URI location, long start, long end, boolean isCheckpoint) {
        this.mLocation = location;
        this.mStart = start;
        this.mEnd = end;
        this.mIsCheckpoint = isCheckpoint;
    }

    static UfsJournalFile createCheckpointFile(URI location, long end) {
        return new UfsJournalFile(location, 0L, end, true);
    }

    static UfsJournalFile createLogFile(URI location, long start, long end) {
        return new UfsJournalFile(location, start, end, false);
    }

    static UfsJournalFile createTmpCheckpointFile(URI location) {
        return new UfsJournalFile(location, Long.MAX_VALUE, Long.MAX_VALUE, false);
    }

    static URI encodeCheckpointFileLocation(UfsJournal journal, long end) {
        String filename = String.format("0x%x-0x%x", 0, end);
        URI location = URIUtils.appendPathOrDie((URI)journal.getCheckpointDir(), (String)filename);
        return location;
    }

    static URI encodeLogFileLocation(UfsJournal journal, long start, long end) {
        String filename = String.format("0x%x-0x%x", start, end);
        URI location = URIUtils.appendPathOrDie((URI)journal.getLogDir(), (String)filename);
        return location;
    }

    static URI encodeTemporaryCheckpointFileLocation(UfsJournal journal) {
        return URIUtils.appendPathOrDie((URI)journal.getTmpDir(), (String)UUID.randomUUID().toString());
    }

    @Nullable
    static UfsJournalFile decodeLogFile(UfsJournal journal, String filename) {
        URI location = URIUtils.appendPathOrDie((URI)journal.getLogDir(), (String)filename);
        try {
            String[] parts = filename.split("-");
            if (parts.length != 2) {
                return null;
            }
            long start = Long.decode(parts[0]);
            long end = Long.decode(parts[1]);
            return UfsJournalFile.createLogFile(location, start, end);
        }
        catch (IllegalStateException e) {
            LOG.error("Illegal journal file {}.", (Object)location);
            throw e;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    static UfsJournalFile decodeCheckpointFile(UfsJournal journal, String filename) {
        URI location = URIUtils.appendPathOrDie((URI)journal.getCheckpointDir(), (String)filename);
        try {
            String[] parts = filename.split("-");
            if (parts.length != 2) {
                return null;
            }
            long start = Long.decode(parts[0]);
            long end = Long.decode(parts[1]);
            Preconditions.checkState((start == 0L ? 1 : 0) != 0);
            return UfsJournalFile.createCheckpointFile(location, end);
        }
        catch (IllegalStateException e) {
            LOG.error("Illegal journal file {}.", (Object)location);
            throw e;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static UfsJournalFile decodeTemporaryCheckpointFile(UfsJournal journal, String filename) {
        URI location = URIUtils.appendPathOrDie((URI)journal.getTmpDir(), (String)filename);
        return UfsJournalFile.createTmpCheckpointFile(location);
    }

    @VisibleForTesting
    public URI getLocation() {
        return this.mLocation;
    }

    long getStart() {
        return this.mStart;
    }

    long getEnd() {
        return this.mEnd;
    }

    boolean isCheckpoint() {
        return this.mIsCheckpoint;
    }

    boolean isCompletedLog() {
        return !this.isCheckpoint() && this.mEnd != Long.MAX_VALUE;
    }

    boolean isIncompleteLog() {
        return this.mStart != Long.MAX_VALUE && this.mEnd == Long.MAX_VALUE;
    }

    boolean isTmpCheckpoint() {
        return this.mStart == Long.MAX_VALUE && this.mEnd == Long.MAX_VALUE;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("location", (Object)this.mLocation).add("start", this.mStart).add("end", this.mEnd).add("isCheckpoint", this.mIsCheckpoint).toString();
    }

    @Override
    public int compareTo(UfsJournalFile other) {
        long diff = this.mEnd - other.mEnd;
        if (diff < 0L) {
            return -1;
        }
        if (diff == 0L) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof UfsJournalFile)) {
            return false;
        }
        UfsJournalFile other = (UfsJournalFile)o;
        return this.mLocation.equals(other.mLocation) && this.mIsCheckpoint == other.mIsCheckpoint && this.mStart == other.mStart && this.mEnd == other.mEnd;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mLocation, this.mIsCheckpoint, this.mStart, this.mEnd});
    }
}

