/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.ufs;

import alluxio.master.journal.ufs.UfsJournal;
import alluxio.master.journal.ufs.UfsJournalFile;
import alluxio.master.journal.ufs.UfsJournalSnapshot;
import alluxio.underfs.UnderFileSystem;
import com.google.common.base.Preconditions;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URI;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class UfsJournalCheckpointWriter
extends FilterOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(UfsJournalCheckpointWriter.class);
    private final UfsJournal mJournal;
    private final UnderFileSystem mUfs;
    private final UfsJournalFile mCheckpointFile;
    private final URI mTmpCheckpointFileLocation;
    private boolean mClosed;

    private UfsJournalCheckpointWriter(UfsJournal journal, URI tmpPath, UfsJournalFile checkpointFile) throws IOException {
        super(journal.getUfs().create(tmpPath.toString()));
        this.mJournal = (UfsJournal)Preconditions.checkNotNull((Object)journal, (Object)"journal");
        this.mUfs = this.mJournal.getUfs();
        this.mTmpCheckpointFileLocation = tmpPath;
        this.mCheckpointFile = checkpointFile;
    }

    public static UfsJournalCheckpointWriter create(UfsJournal journal, long snapshotSequenceNumber) throws IOException {
        URI tmpPath = UfsJournalFile.encodeTemporaryCheckpointFileLocation(journal);
        URI finalPath = UfsJournalFile.encodeCheckpointFileLocation(journal, snapshotSequenceNumber);
        UfsJournalFile checkpointFile = UfsJournalFile.createCheckpointFile(finalPath, snapshotSequenceNumber);
        return new UfsJournalCheckpointWriter(journal, tmpPath, checkpointFile);
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.out.write(b, offset, length);
    }

    @Override
    public void close() throws IOException {
        block10: {
            if (this.mClosed) {
                return;
            }
            this.mClosed = true;
            this.out.close();
            UfsJournalFile latestCheckpoint = UfsJournalSnapshot.getSnapshot(this.mJournal).getLatestCheckpoint();
            if (latestCheckpoint != null && this.mCheckpointFile.getEnd() <= latestCheckpoint.getEnd()) {
                this.mUfs.deleteFile(this.mTmpCheckpointFileLocation.toString());
                return;
            }
            try {
                this.mUfs.mkdirs(this.mJournal.getCheckpointDir().toString());
            }
            catch (IOException e) {
                if (this.mUfs.exists(this.mJournal.getCheckpointDir().toString())) break block10;
                LOG.warn("Failed to create the checkpoint directory {}.", (Object)this.mJournal.getCheckpointDir());
                throw e;
            }
        }
        String dst = this.mCheckpointFile.getLocation().toString();
        try {
            if (!this.mUfs.renameFile(this.mTmpCheckpointFileLocation.toString(), dst)) {
                throw new IOException(String.format("Failed to rename %s to %s.", this.mTmpCheckpointFileLocation.toString(), dst));
            }
        }
        catch (IOException e) {
            if (!this.mUfs.exists(dst)) {
                LOG.warn("Failed to commit checkpoint from {} to {} with error {}.", new Object[]{this.mTmpCheckpointFileLocation, dst, e.toString()});
            }
            try {
                this.mUfs.deleteFile(this.mTmpCheckpointFileLocation.toString());
            }
            catch (IOException ee) {
                LOG.warn("Failed to clean up temporary checkpoint {} at entry {}.", (Object)this.mTmpCheckpointFileLocation, (Object)this.mCheckpointFile.getEnd());
            }
            throw e;
        }
    }

    public void cancel() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.out.close();
        if (this.mUfs.exists(this.mTmpCheckpointFileLocation.toString())) {
            this.mUfs.deleteFile(this.mTmpCheckpointFileLocation.toString());
        }
    }
}

